/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IndeterminateOperationStateException;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.PacketFiltersUtil;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientIndeterminateOperationStateExceptionTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private HazelcastInstance instance1;
    private HazelcastInstance instance2;
    private HazelcastInstance client;

    @Before
    public void init() {
        Config config = new Config();
        config.setProperty(GroupProperty.OPERATION_BACKUP_TIMEOUT_MILLIS.getName(), String.valueOf(1000));
        config.setProperty(GroupProperty.FAIL_ON_INDETERMINATE_OPERATION_STATE.getName(), String.valueOf(true));
        this.instance1 = this.factory.newHazelcastInstance(config);
        this.instance2 = this.factory.newHazelcastInstance(config);
        this.client = this.factory.newHazelcastClient();
        ClientIndeterminateOperationStateExceptionTest.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{this.instance1, this.instance2});
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void shouldFail_whenBackupAckMissed() throws InterruptedException, TimeoutException {
        PacketFiltersUtil.dropOperationsBetween((HazelcastInstance)this.instance1, (HazelcastInstance)this.instance2, (int)SpiDataSerializerHook.F_ID, Collections.singletonList(1));
        String key = ClientIndeterminateOperationStateExceptionTest.generateKeyOwnedBy((HazelcastInstance)this.instance1);
        IMap map = this.client.getMap(ClientIndeterminateOperationStateExceptionTest.randomMapName());
        try {
            map.put((Object)key, (Object)key);
            Assert.fail();
        }
        catch (IndeterminateOperationStateException indeterminateOperationStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)key, (Object)map.get((Object)key));
    }
}

