/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.client.map.AbstractClientMapTest;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapBasicTest
extends AbstractClientMapTest {
    @Test
    public void testClientGetMap() {
        Assert.assertNotNull((Object)client.getMap(ClientMapBasicTest.randomString()));
    }

    @Test
    public void testGetName() {
        String mapName = ClientMapBasicTest.randomString();
        IMap map = client.getMap(mapName);
        Assert.assertEquals((Object)mapName, (Object)map.getName());
    }

    @Test
    public void testSize_whenEmpty() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testSize() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.put((Object)"key", (Object)"val");
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testSize_withMultiKeyPuts() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "Val";
        map.put((Object)key, (Object)oldValue);
        map.put((Object)key, (Object)newValue);
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testIsEmpty_whenEmpty() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testIsEmpty_whenNotEmpty() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.put((Object)"key", (Object)"val");
        Assert.assertFalse((boolean)map.isEmpty());
    }

    @Test
    public void testIsEmpty_afterPutRemove() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "key";
        map.put((Object)key, (Object)"val");
        map.remove((Object)key);
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void testPut_whenKeyNull() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String val = "Val";
        map.put(null, (Object)val);
    }

    @Test(expected=NullPointerException.class)
    public void testPut_whenValueNull() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        map.put((Object)key, null);
    }

    @Test
    public void testPut() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Val";
        String result = (String)map.put((Object)key, (Object)value);
        Assert.assertNull((Object)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPut_whenKeyExists() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "Val";
        map.put((Object)key, (Object)oldValue);
        String result = (String)map.put((Object)key, (Object)newValue);
        Assert.assertEquals((Object)oldValue, (Object)result);
        Assert.assertEquals((Object)newValue, (Object)map.get((Object)key));
    }

    @Test
    public void testPutTTL() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        String result = (String)map.put((Object)key, (Object)value, 5L, TimeUnit.MINUTES);
        Assert.assertNull((Object)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutTTL_whenKeyExists() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "Val";
        map.put((Object)key, (Object)oldValue);
        String result = (String)map.put((Object)key, (Object)newValue, 5L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)oldValue, (Object)result);
        Assert.assertEquals((Object)newValue, (Object)map.get((Object)key));
    }

    @Test
    public void testPutTTL_AfterExpire() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        String result = (String)map.put((Object)key, (Object)value, 1L, TimeUnit.SECONDS);
        Assert.assertNull((Object)result);
        ClientMapBasicTest.sleepSeconds((int)2);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testPutTTL_AfterExpireWhenKeyExists() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "Val";
        map.put((Object)key, (Object)oldValue);
        String result = (String)map.put((Object)key, (Object)newValue, 1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)oldValue, (Object)result);
        ClientMapBasicTest.sleepSeconds((int)2);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testPutAsync() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Val";
        ICompletableFuture result = map.putAsync((Object)key, (Object)value);
        Assert.assertNull(result.get());
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutAsync_whenKeyExists() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "Val";
        map.put((Object)key, (Object)oldValue);
        ICompletableFuture result = map.putAsync((Object)key, (Object)newValue);
        Assert.assertEquals((Object)oldValue, result.get());
        Assert.assertEquals((Object)newValue, (Object)map.get((Object)key));
    }

    @Test(expected=NullPointerException.class)
    public void testPutAsync_withKeyNull() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String val = "Val";
        map.putAsync(null, (Object)val);
    }

    @Test(expected=NullPointerException.class)
    public void testPutAsync_withValueNull() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "key";
        map.putAsync((Object)key, null);
    }

    @Test
    public void testPutAsyncTTL() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Val";
        ICompletableFuture result = map.putAsync((Object)key, (Object)value, 5L, TimeUnit.MINUTES);
        Assert.assertNull(result.get());
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutAsyncTTL_whenKeyExists() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "Val";
        map.put((Object)key, (Object)oldValue);
        ICompletableFuture result = map.putAsync((Object)key, (Object)newValue, 5L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)oldValue, result.get());
        Assert.assertEquals((Object)newValue, (Object)map.get((Object)key));
    }

    @Test
    public void testPutAsyncTTL_afterExpire() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Val";
        ICompletableFuture result = map.putAsync((Object)key, (Object)value, 1L, TimeUnit.SECONDS);
        Assert.assertNull(result.get());
        ClientMapBasicTest.sleepSeconds((int)2);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testPutAsyncTTL_afterExpireWhenKeyExists() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "Val";
        map.put((Object)key, (Object)oldValue);
        ICompletableFuture result = map.putAsync((Object)key, (Object)newValue, 1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)oldValue, result.get());
        ClientMapBasicTest.sleepSeconds((int)2);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testSetAsync() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Val";
        ICompletableFuture result = map.setAsync((Object)key, (Object)value);
        result.get();
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test(expected=NullPointerException.class)
    public void testSetAsync_withKeyNull() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String val = "Val";
        map.setAsync(null, (Object)val);
    }

    @Test(expected=NullPointerException.class)
    public void testSetAsync_withValueNull() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "key";
        map.setAsync((Object)key, null);
    }

    @Test
    public void testSetAsyncTTL() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Val";
        ICompletableFuture result = map.setAsync((Object)key, (Object)value, 5L, TimeUnit.MINUTES);
        result.get();
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testSetAsyncTTL_afterExpire() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Val";
        final CountDownLatch latch = new CountDownLatch(1);
        map.addEntryListener((MapListener)new EntryEvictedListener<String, String>(){

            public void entryEvicted(EntryEvent<String, String> event) {
                latch.countDown();
            }
        }, true);
        ICompletableFuture result = map.setAsync((Object)key, (Object)value, 1L, TimeUnit.SECONDS);
        result.get();
        ClientMapBasicTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testSetAsyncTTL_afterExpireWhenKeyExists() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "Val";
        final CountDownLatch latch = new CountDownLatch(1);
        map.addEntryListener((MapListener)new EntryEvictedListener<String, String>(){

            public void entryEvicted(EntryEvent<String, String> event) {
                latch.countDown();
            }
        }, true);
        map.set((Object)key, (Object)oldValue);
        ICompletableFuture result = map.setAsync((Object)key, (Object)newValue, 1L, TimeUnit.SECONDS);
        result.get();
        ClientMapBasicTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testTryPut_whenNotLocked() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        boolean result = map.tryPut((Object)key, (Object)value, 1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testTryPut_whenKeyPresentAndNotLocked() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "Val";
        map.put((Object)key, (Object)oldValue);
        boolean result = map.tryPut((Object)key, (Object)newValue, 1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)newValue, (Object)map.get((Object)key));
    }

    @Test(expected=NullPointerException.class)
    public void testPutIfAbsent_whenKeyNull() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String value = "Value";
        map.putIfAbsent(null, (Object)value);
    }

    @Test(expected=NullPointerException.class)
    public void testPutIfAbsent_whenValueNull() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "key";
        map.putIfAbsent((Object)key, null);
    }

    @Test
    public void testPutIfAbsent() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        String result = (String)map.putIfAbsent((Object)key, (Object)value);
        Assert.assertNull((Object)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutIfAbsent_whenKeyPresent() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        map.put((Object)key, (Object)value);
        String result = (String)map.putIfAbsent((Object)key, (Object)value);
        Assert.assertEquals((Object)value, (Object)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutIfAbsentNewValue_whenKeyPresent() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        String newValue = "newValue";
        map.put((Object)key, (Object)value);
        String result = (String)map.putIfAbsent((Object)key, (Object)newValue);
        Assert.assertEquals((Object)value, (Object)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutIfAbsentTTL() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        String result = (String)map.putIfAbsent((Object)key, (Object)value, 5L, TimeUnit.MINUTES);
        Assert.assertNull((Object)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutIfAbsentTTL_whenExpire() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        String result = (String)map.putIfAbsent((Object)key, (Object)value, 1L, TimeUnit.SECONDS);
        ClientMapBasicTest.sleepSeconds((int)2);
        Assert.assertNull((Object)result);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testPutIfAbsentTTL_whenKeyPresentAfterExpire() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        map.put((Object)key, (Object)value);
        String result = (String)map.putIfAbsent((Object)key, (Object)value, 1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)value, (Object)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutIfAbsentTTL_whenKeyPresent() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        map.put((Object)key, (Object)value);
        String result = (String)map.putIfAbsent((Object)key, (Object)value, 5L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)value, (Object)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutIfAbsentNewValueTTL_whenKeyPresent() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        String newValue = "newValue";
        map.put((Object)key, (Object)value);
        String result = (String)map.putIfAbsent((Object)key, (Object)newValue, 5L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)value, (Object)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testClear_whenEmpty() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testClear() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        map.put((Object)key, (Object)value);
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testContainsKey_whenKeyAbsent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        Assert.assertFalse((boolean)map.containsKey((Object)"NOT_THERE"));
    }

    @Test(expected=NullPointerException.class)
    public void testContainsKey_whenKeyNull() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.containsKey(null);
    }

    @Test
    public void testContainsKey_whenKeyPresent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "key";
        map.put((Object)key, (Object)"val");
        Assert.assertTrue((boolean)map.containsKey((Object)key));
    }

    @Test
    public void testContainsValue_whenValueAbsent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        Assert.assertFalse((boolean)map.containsValue((Object)"NOT_THERE"));
    }

    @Test(expected=NullPointerException.class)
    public void testContainsValue_whenValueNull() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.containsValue(null);
    }

    @Test
    public void testContainsValue_whenValuePresent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "key";
        String value = "value";
        map.put((Object)key, (Object)value);
        Assert.assertTrue((boolean)map.containsValue((Object)value));
    }

    @Test
    public void testContainsValue_whenMultiValuePresent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String value = "value";
        map.put((Object)"key1", (Object)value);
        map.put((Object)"key2", (Object)value);
        Assert.assertTrue((boolean)map.containsValue((Object)value));
    }

    @Test
    public void testGet_whenKeyPresent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String val = "Val";
        map.put((Object)key, (Object)val);
        Assert.assertEquals((Object)val, (Object)map.get((Object)key));
    }

    @Test
    public void testGet_whenKeyAbsent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        Assert.assertNull((Object)map.get((Object)"NOT_THERE"));
    }

    @Test(expected=NullPointerException.class)
    public void testGet_whenKeyNull() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.get(null);
    }

    @Test
    public void testGetAsync_whenKeyPresent() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String val = "Val";
        map.put((Object)key, (Object)val);
        ICompletableFuture result = map.getAsync((Object)key);
        Assert.assertEquals((Object)val, result.get());
    }

    @Test
    public void testGetAsync_whenKeyAbsent() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        ICompletableFuture result = map.getAsync((Object)"NOT_THERE");
        Assert.assertNull(result.get());
    }

    @Test(expected=NullPointerException.class)
    public void testGetAsync_whenKeyNull() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.getAsync(null);
    }

    @Test
    public void testMapSet() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String val = "Val";
        map.set((Object)key, (Object)val);
        Assert.assertEquals((Object)val, (Object)map.get((Object)key));
    }

    @Test
    public void testMapSet_whenKeyPresent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "Val";
        String newValue = "newValue";
        map.set((Object)key, (Object)oldValue);
        map.set((Object)key, (Object)newValue);
        Assert.assertEquals((Object)newValue, (Object)map.get((Object)key));
    }

    @Test
    public void testMapSetTTl() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String val = "Val";
        map.set((Object)key, (Object)val, 5L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)val, (Object)map.get((Object)key));
    }

    @Test
    public void testMapSetTTl_whenExpired() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String val = "Val";
        map.set((Object)key, (Object)val, 1L, TimeUnit.SECONDS);
        ClientMapBasicTest.sleepSeconds((int)2);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testMapSetTTl_whenReplacingKeyAndExpired() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String newValue = "newValue";
        String oldValue = "oldvalue";
        map.set((Object)key, (Object)oldValue);
        map.set((Object)key, (Object)newValue, 1L, TimeUnit.SECONDS);
        ClientMapBasicTest.sleepSeconds((int)2);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testRemove_WhenKeyAbsent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        Assert.assertNull((Object)map.remove((Object)"NOT_THERE"));
    }

    @Test(expected=NullPointerException.class)
    public void testRemove_WhenKeyNull() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        Assert.assertNull((Object)map.remove(null));
    }

    @Test
    public void testRemove_WhenKeyPresent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.put((Object)key, (Object)value);
        Assert.assertEquals((Object)value, (Object)map.remove((Object)key));
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testRemoveKeyValue_WhenPresent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.put((Object)key, (Object)value);
        Assert.assertTrue((boolean)map.remove((Object)key, (Object)value));
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testRemoveKeyValue_WhenValueAbsent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.put((Object)key, (Object)value);
        Assert.assertFalse((boolean)map.remove((Object)key, (Object)"NOT_THERE"));
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testRemoveKeyValue_WhenKeyAbsent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.put((Object)key, (Object)value);
        Assert.assertFalse((boolean)map.remove((Object)"NOT_THERE", (Object)value));
    }

    @Test
    public void testRemoveAsync() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.put((Object)key, (Object)value);
        ICompletableFuture result = map.removeAsync((Object)key);
        Assert.assertEquals((Object)value, result.get());
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testRemoveAsync_whenKeyNotPresent() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        ICompletableFuture result = map.removeAsync((Object)"NOT_THERE");
        Assert.assertNull(result.get());
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveAsync_whenKeyNull() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.removeAsync(null);
    }

    @Test
    public void testTryRemove_WhenKeyPresentAndNotLocked() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.put((Object)key, (Object)value);
        boolean result = map.tryRemove((Object)key, 1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)result);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testTryRemove_WhenKeyAbsentAndNotLocked() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        boolean result = map.tryRemove((Object)key, 1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)result);
    }

    @Test(expected=NullPointerException.class)
    public void testDelete_whenKeyNull() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.delete(null);
    }

    @Test
    public void testDelete_whenKeyPresent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.put((Object)key, (Object)value);
        map.delete((Object)key);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testDelete_whenKeyAbsent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.put((Object)key, (Object)value);
        map.delete((Object)"NOT_THERE");
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testEvict_whenKeyAbsent() throws InterruptedException {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        boolean result = map.evict((Object)"NOT_THERE");
        Assert.assertFalse((boolean)result);
    }

    @Test(expected=NullPointerException.class)
    public void testEvict_whenKeyNull() throws InterruptedException {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.evict(null);
    }

    @Test
    public void testEvict() throws InterruptedException {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.put((Object)key, (Object)value);
        boolean result = map.evict((Object)key);
        Assert.assertTrue((boolean)result);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testPutAll() {
        int max = 100;
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        for (int i = 0; i < max; ++i) {
            expected.put(i, i);
        }
        map.putAll(expected);
        Assert.assertEquals((long)max, (long)map.size());
        for (Integer key : expected.keySet()) {
            Integer value = (Integer)map.get((Object)key);
            Integer expectedValue = (Integer)expected.get(key);
            Assert.assertEquals((Object)expectedValue, (Object)value);
        }
    }

    @Test
    public void testGetAll() {
        int max = 100;
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        for (int i = 0; i < max; ++i) {
            map.put((Object)i, (Object)i);
            expected.put(i, i);
        }
        Map result = map.getAll(expected.keySet());
        for (Integer key : expected.keySet()) {
            Integer value = (Integer)result.get(key);
            Integer expectedValue = (Integer)expected.get(key);
            Assert.assertEquals((Object)expectedValue, (Object)value);
        }
    }

    public void testGetAll_whenMapEmpty() {
        int max = 10;
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        for (int i = 0; i < max; ++i) {
            expected.put(i, i);
        }
        Map result = map.getAll(expected.keySet());
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testReplace_whenKeyValueAbsent() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        Assert.assertNull((Object)map.replace((Object)key, (Object)value));
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testReplace() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "value";
        String newValue = "NewValue";
        map.put((Object)key, (Object)oldValue);
        String result = (String)map.replace((Object)key, (Object)newValue);
        Assert.assertEquals((Object)oldValue, (Object)result);
        Assert.assertEquals((Object)newValue, (Object)map.get((Object)key));
    }

    @Test
    public void testReplaceKeyValue() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        String newValue = "NewValue";
        map.put((Object)key, (Object)value);
        boolean result = map.replace((Object)key, (Object)value, (Object)newValue);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)newValue, (Object)map.get((Object)key));
    }

    @Test
    public void testReplaceKeyValue_whenValueAbsent() throws Exception {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        String newValue = "NewValue";
        map.put((Object)key, (Object)value);
        boolean result = map.replace((Object)key, (Object)"NOT_THERE", (Object)newValue);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutTransient() throws InterruptedException {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.putTransient((Object)key, (Object)value, 5L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testPutTransient_whenExpire() throws InterruptedException {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "value";
        map.putTransient((Object)key, (Object)value, 1L, TimeUnit.SECONDS);
        ClientMapBasicTest.sleepSeconds((int)2);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testPutTransient_whenKeyPresent() throws InterruptedException {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "newValue";
        map.put((Object)key, (Object)oldValue);
        map.putTransient((Object)key, (Object)newValue, 5L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)newValue, (Object)map.get((Object)key));
    }

    @Test
    public void testPutTransient_whenKeyPresentAfterExpire() throws InterruptedException {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String oldValue = "oldValue";
        String newValue = "newValue";
        map.put((Object)key, (Object)oldValue);
        map.putTransient((Object)key, (Object)newValue, 1L, TimeUnit.SECONDS);
        ClientMapBasicTest.sleepSeconds((int)2);
        Assert.assertNull((Object)map.get((Object)key));
    }

    @Test
    public void testGetEntryView_whenKeyAbsent() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        EntryView view = map.getEntryView((Object)"NOT_THERE");
        Assert.assertNull((Object)view);
    }

    @Test
    public void testGetEntryView() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        String key = "Key";
        String value = "Value";
        map.put((Object)key, (Object)value);
        EntryView view = map.getEntryView((Object)key);
        Assert.assertEquals((Object)key, (Object)view.getKey());
        Assert.assertEquals((Object)value, (Object)view.getValue());
    }

    @Test
    public void testKeySet_whenEmpty() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        Set keySet = map.keySet();
        Assert.assertTrue((boolean)keySet.isEmpty());
    }

    @Test
    public void testKeySet() {
        int max = 81;
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        TreeSet<Integer> expected = new TreeSet<Integer>();
        for (int key = 0; key < max; ++key) {
            String value = key + "value";
            expected.add(key);
            map.put((Object)key, (Object)value);
        }
        Set keySet = map.keySet();
        Assert.assertEquals(expected, (Object)keySet);
    }

    @Test
    public void testKeySet_withPredicate() {
        int max = 44;
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        TreeSet<Integer> expected = new TreeSet<Integer>();
        for (int key = 0; key < max; ++key) {
            String value = key + "value";
            map.put((Object)key, (Object)value);
        }
        expected.add(4);
        Set keySet = map.keySet((Predicate)new SqlPredicate("this == 4value"));
        Assert.assertEquals(expected, (Object)keySet);
    }

    @Test
    public void testValues_whenEmpty() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        Collection values = map.values();
        Assert.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testValues() {
        int max = 23;
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        TreeSet<String> expected = new TreeSet<String>();
        for (int key = 0; key < max; ++key) {
            String value = key + "value";
            expected.add(value);
            map.put((Object)key, (Object)value);
        }
        Collection collection = map.values();
        TreeSet resultSet = new TreeSet(collection);
        Assert.assertEquals(expected, resultSet);
    }

    @Test
    public void testValues_withPredicate() {
        int max = 27;
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        TreeSet<String> expected = new TreeSet<String>();
        for (int key = 0; key < max; ++key) {
            String value = key + "value";
            map.put((Object)key, (Object)value);
        }
        expected.add("4value");
        Collection collection = map.values((Predicate)new SqlPredicate("this == 4value"));
        TreeSet resultSet = new TreeSet(collection);
        Assert.assertEquals(expected, resultSet);
    }

    @Test
    public void testEntrySet_whenEmpty() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        Set entrySet = map.entrySet();
        Assert.assertTrue((boolean)entrySet.isEmpty());
    }

    @Test
    public void testEntrySet() {
        int max = 34;
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        HashMap<Integer, String> expected = new HashMap<Integer, String>();
        for (int key = 0; key < max; ++key) {
            String value = key + "value";
            expected.put(key, value);
            map.put((Object)key, (Object)value);
        }
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            Integer key = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            String expectedValue = (String)expected.get(key);
            Assert.assertEquals((Object)expectedValue, (Object)value);
        }
    }

    @Test
    public void github_11489_verifyNoFailingCastOnValue() throws Exception {
        IMap test = client.getMap("github_11489");
        for (int i = 0; i < 1000; ++i) {
            test.put((Object)i, (Object)i);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String result = objectMapper.writeValueAsString((Object)test.values((Predicate)new TestPagingPredicate(1000)));
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testEntrySet_withPredicate() {
        int max = 44;
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        for (int key = 0; key < max; ++key) {
            String value = key + "value";
            map.put((Object)key, (Object)value);
        }
        Set entrySet = map.entrySet((Predicate)new SqlPredicate("this == 1value"));
        Assert.assertEquals((long)1L, (long)entrySet.size());
        Map.Entry entry = (Map.Entry)entrySet.iterator().next();
        Assert.assertEquals((long)1L, (long)((Integer)entry.getKey()).intValue());
        Assert.assertEquals((Object)"1value", entry.getValue());
    }

    @Test
    public void testMapStatistics_withClientOperations() {
        String mapName = ClientMapBasicTest.randomString();
        IMap member1Map = member1.getMap(mapName);
        member1Map.addInterceptor((MapInterceptor)new DelayGetRemoveMapInterceptor());
        LocalMapStats stats1 = member1Map.getLocalMapStats();
        LocalMapStats stats2 = member2.getMap(mapName).getLocalMapStats();
        IMap map = client.getMap(mapName);
        int operationCount = 1123;
        for (int i = 0; i < operationCount; ++i) {
            map.put((Object)i, (Object)i);
            map.get((Object)i);
            map.remove((Object)i);
        }
        Assert.assertEquals((String)("put count: stats1" + stats1 + " stats2:" + stats2), (long)operationCount, (long)(stats1.getPutOperationCount() + stats2.getPutOperationCount()));
        Assert.assertEquals((String)("get count : stats1" + stats1 + " stats2:" + stats2), (long)operationCount, (long)(stats1.getGetOperationCount() + stats2.getGetOperationCount()));
        Assert.assertEquals((String)("remove count : stats1" + stats1 + " stats2:" + stats2), (long)operationCount, (long)(stats1.getRemoveOperationCount() + stats2.getRemoveOperationCount()));
        Assert.assertTrue((String)("put latency : stats1" + stats1 + " stats2:" + stats2), (0L < stats1.getTotalPutLatency() + stats2.getTotalPutLatency() ? 1 : 0) != 0);
        Assert.assertTrue((String)("get latency : stats1" + stats1 + " stats2:" + stats2), (0L < stats1.getTotalGetLatency() + stats2.getTotalGetLatency() ? 1 : 0) != 0);
        Assert.assertTrue((String)("remove latency : stats1" + stats1 + " stats2:" + stats2), (0L < stats1.getTotalRemoveLatency() + stats2.getTotalRemoveLatency() ? 1 : 0) != 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListener() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.addLocalEntryListener((EntryListener)new EmptyEntryListener());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListener_WithPredicate() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.addLocalEntryListener((EntryListener)new EmptyEntryListener(), (Predicate)new FalsePredicate(), true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListener_WithPredicateAndKey() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.addLocalEntryListener((EntryListener)new EmptyEntryListener(), (Predicate)new FalsePredicate(), (Object)"Key", true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLocalKeySet() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.localKeySet();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLocalKeySet_WithPredicate() {
        IMap map = client.getMap(ClientMapBasicTest.randomString());
        map.localKeySet((Predicate)new FalsePredicate());
    }

    private static class FalsePredicate
    implements Predicate<String, String> {
        private FalsePredicate() {
        }

        public boolean apply(Map.Entry mapEntry) {
            return false;
        }
    }

    private static class EmptyEntryListener
    implements EntryListener<String, String> {
        private EmptyEntryListener() {
        }

        public void entryAdded(EntryEvent event) {
        }

        public void entryRemoved(EntryEvent event) {
        }

        public void entryUpdated(EntryEvent event) {
        }

        public void entryEvicted(EntryEvent event) {
        }

        public void mapEvicted(MapEvent event) {
        }

        public void mapCleared(MapEvent event) {
        }
    }

    private static class DelayGetRemoveMapInterceptor
    implements MapInterceptor,
    Serializable {
        private DelayGetRemoveMapInterceptor() {
        }

        public Object interceptGet(Object value) {
            HazelcastTestSupport.sleepMillis((int)1);
            return value;
        }

        public void afterGet(Object value) {
        }

        public Object interceptPut(Object oldValue, Object newValue) {
            HazelcastTestSupport.sleepMillis((int)1);
            return newValue;
        }

        public void afterPut(Object value) {
        }

        public Object interceptRemove(Object removedValue) {
            HazelcastTestSupport.sleepMillis((int)1);
            return removedValue;
        }

        public void afterRemove(Object value) {
        }
    }

    private static class TestPagingPredicate
    extends PagingPredicate {
        public TestPagingPredicate(int pageSize) {
            super(pageSize);
        }

        public boolean apply(Map.Entry mapEntry) {
            return true;
        }
    }
}

