/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapStore;
import com.hazelcast.core.MapStoreAdapter;
import com.hazelcast.map.impl.mapstore.AbstractMapStoreTest;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapLoaderExceptionHandlingTest
extends AbstractMapStoreTest {
    private static final String mapName = ClientMapLoaderExceptionHandlingTest.randomMapName();
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private ExceptionalMapStore mapStore;

    @Before
    public void setup() {
        this.mapStore = new ExceptionalMapStore();
        Config config = this.createNewConfig(mapName, (MapStore)this.mapStore);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void configureMapStore() {
        this.mapStore.setLoadAllKeysThrows(false);
    }

    @Test
    public void test_initial_map_load_propagates_exception_to_client() throws Exception {
        final IMap map = this.client.getMap(mapName);
        ClientMapLoaderExceptionHandlingTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Exception exception = null;
                try {
                    map.get((Object)1);
                }
                catch (Exception e) {
                    exception = e;
                }
                Assert.assertNotNull((String)"Exception not propagated to client", (Object)exception);
                Assert.assertEquals(ClassCastException.class, exception.getClass());
            }
        });
    }

    @Test
    public void testClientGetsException_whenLoadAllKeysThrowsOne() throws Exception {
        this.mapStore.setLoadAllKeysThrows(true);
        IMap map = this.client.getMap(mapName);
        Exception exception = null;
        try {
            map.get((Object)1);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertNotNull((String)"Exception not propagated to client", (Object)exception);
        Assert.assertEquals(IllegalStateException.class, exception.getClass());
    }

    private Config createNewConfig(String mapName, MapStore store) {
        return this.newConfig(mapName, store, 0);
    }

    private static class ExceptionalMapStore
    extends MapStoreAdapter {
        private boolean loadAllKeysThrows = false;

        private ExceptionalMapStore() {
        }

        public Set loadAllKeys() {
            Preconditions.checkState((!this.loadAllKeysThrows ? 1 : 0) != 0, (String)((Object)((Object)this)).getClass().getName());
            HashSet<Integer> integers = new HashSet<Integer>();
            for (int i = 0; i < 1000; ++i) {
                integers.add(i);
            }
            return integers;
        }

        public Map loadAll(Collection keys) {
            throw new ClassCastException("ExceptionalMapStore.loadAll");
        }

        public void setLoadAllKeysThrows(boolean loadAllKeysThrows) {
            this.loadAllKeysThrows = loadAllKeysThrows;
        }
    }
}

