/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.map.helpers.AMapStore;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapStore;
import com.hazelcast.map.ReachedMaxSizeException;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={SlowTest.class})
public class ClientMapStoreTest
extends HazelcastTestSupport {
    private static final String MAP_NAME = "clientMapStoreLoad";
    private TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private Config nodeConfig;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.nodeConfig = this.getConfig();
        MapConfig mapConfig = new MapConfig();
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        mapStoreConfig.setEnabled(true);
        mapStoreConfig.setImplementation((Object)new SimpleMapStore());
        mapStoreConfig.setInitialLoadMode(MapStoreConfig.InitialLoadMode.EAGER);
        mapConfig.setName(MAP_NAME);
        mapConfig.setMapStoreConfig(mapStoreConfig);
        this.nodeConfig.addMapConfig(mapConfig);
    }

    @Test
    public void testOneClient_KickOffMapStoreLoad() {
        this.hazelcastFactory.newHazelcastInstance(this.nodeConfig);
        ClientThread client1 = new ClientThread();
        client1.start();
        ClientMapStoreTest.assertJoinable((Thread[])new Thread[]{client1});
        ClientMapStoreTest.assertSizeEventually((int)30, client1.map);
    }

    @Test
    public void testTwoClient_KickOffMapStoreLoad() {
        this.hazelcastFactory.newHazelcastInstance(this.nodeConfig);
        Thread[] clientThreads = new ClientThread[2];
        for (int i = 0; i < clientThreads.length; ++i) {
            ClientThread client1 = new ClientThread();
            client1.start();
            clientThreads[i] = client1;
        }
        ClientMapStoreTest.assertJoinable((Thread[])clientThreads);
        for (Thread c : clientThreads) {
            ClientMapStoreTest.assertSizeEventually((int)30, ((ClientThread)c).map);
        }
    }

    @Test
    public void testOneClientKickOffMapStoreLoad_ThenNodeJoins() {
        this.hazelcastFactory.newHazelcastInstance(this.nodeConfig);
        ClientThread client1 = new ClientThread();
        client1.start();
        this.hazelcastFactory.newHazelcastInstance(this.nodeConfig);
        ClientMapStoreTest.assertJoinable((Thread[])new Thread[]{client1});
        ClientMapStoreTest.assertSizeEventually((int)30, client1.map);
    }

    @Test
    public void testForIssue2112() {
        this.hazelcastFactory.newHazelcastInstance(this.nodeConfig);
        IMap map = this.hazelcastFactory.newHazelcastClient().getMap(MAP_NAME);
        ClientMapStoreTest.assertSizeEventually((int)30, (Map)map);
        this.hazelcastFactory.newHazelcastInstance(this.nodeConfig);
        map = this.hazelcastFactory.newHazelcastClient().getMap(MAP_NAME);
        ClientMapStoreTest.assertSizeEventually((int)30, (Map)map);
    }

    @Test
    public void mapSize_After_MapStore_OperationQueue_OverFlow() throws Exception {
        int maxCapacity = 1000;
        Config config = this.getConfig();
        config.setProperty(GroupProperty.MAP_WRITE_BEHIND_QUEUE_CAPACITY.getName(), String.valueOf(maxCapacity));
        MapConfig mapConfig = new MapConfig();
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        MapStoreBackup store = new MapStoreBackup();
        int delaySeconds = Integer.MAX_VALUE;
        mapStoreConfig.setEnabled(true);
        mapStoreConfig.setImplementation((Object)store);
        mapStoreConfig.setWriteDelaySeconds(delaySeconds);
        mapStoreConfig.setWriteCoalescing(false);
        mapConfig.setName(MAP_NAME);
        mapConfig.setMapStoreConfig(mapStoreConfig);
        config.addMapConfig(mapConfig);
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap(MAP_NAME);
        int overflow = 100;
        ArrayList<ICompletableFuture> futures = new ArrayList<ICompletableFuture>(maxCapacity + overflow);
        for (int i = 0; i < maxCapacity + overflow; ++i) {
            ICompletableFuture future = map.putAsync((Object)i, (Object)i);
            futures.add(future);
        }
        int success = 0;
        for (Future future : futures) {
            try {
                future.get();
                ++success;
            }
            catch (ExecutionException e) {
                ClientMapStoreTest.assertInstanceOf(ReachedMaxSizeException.class, (Object)e.getCause());
            }
        }
        Assert.assertEquals((long)success, (long)maxCapacity);
        Assert.assertEquals((long)map.size(), (long)maxCapacity);
    }

    @Test
    public void mapStore_OperationQueue_AtMaxCapacity() {
        int maxCapacity = 1000;
        Config config = this.getConfig();
        config.setProperty(GroupProperty.MAP_WRITE_BEHIND_QUEUE_CAPACITY.getName(), String.valueOf(maxCapacity));
        MapConfig mapConfig = new MapConfig();
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        MapStoreBackup store = new MapStoreBackup();
        mapStoreConfig.setEnabled(true);
        mapStoreConfig.setImplementation((Object)store);
        mapStoreConfig.setWriteDelaySeconds(60);
        mapStoreConfig.setWriteCoalescing(false);
        mapConfig.setName(MAP_NAME);
        mapConfig.setMapStoreConfig(mapStoreConfig);
        config.addMapConfig(mapConfig);
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap(MAP_NAME);
        for (int i = 0; i < maxCapacity; ++i) {
            map.put((Object)i, (Object)i);
        }
        Assert.assertEquals((long)maxCapacity, (long)map.size());
        try {
            map.put((Object)maxCapacity, (Object)maxCapacity);
            Assert.fail((String)"Should not exceed max capacity");
        }
        catch (ReachedMaxSizeException expected) {
            ClientMapStoreTest.ignore((Throwable)expected);
        }
    }

    @Test
    public void destroyMap_configuredWithMapStore() {
        Config config = this.getConfig();
        MapConfig mapConfig = new MapConfig();
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        MapStoreBackup store = new MapStoreBackup();
        mapStoreConfig.setEnabled(true);
        mapStoreConfig.setImplementation((Object)store);
        mapStoreConfig.setWriteDelaySeconds(4);
        mapConfig.setName(MAP_NAME);
        mapConfig.setMapStoreConfig(mapStoreConfig);
        config.addMapConfig(mapConfig);
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap(MAP_NAME);
        for (int i = 0; i < 1; ++i) {
            map.putAsync((Object)i, (Object)i);
        }
        map.destroy();
    }

    @Test
    public void testIssue3023_testWithSubStringMapNames() {
        String mapNameWithStore = "MapStore*";
        String mapNameWithStoreAndSize = "MapStoreMaxSize*";
        String xml = "<hazelcast xsi:schemaLocation=\"http://www.hazelcast.com/schema/config\n                             http://www.hazelcast.com/schema/config/hazelcast-config-3.10.xsd\"\n                             xmlns=\"http://www.hazelcast.com/schema/config\"\n                             xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n\n    <map name=\"" + mapNameWithStore + "\">\n" + "        <map-store enabled=\"true\">\n" + "            <class-name>com.will.cause.problem.if.used</class-name>\n" + "            <write-delay-seconds>5</write-delay-seconds>\n" + "        </map-store>\n" + "    </map>\n" + "\n" + "    <map name=\"" + mapNameWithStoreAndSize + "\">\n" + "        <in-memory-format>BINARY</in-memory-format>\n" + "        <backup-count>1</backup-count>\n" + "        <async-backup-count>0</async-backup-count>\n" + "        <max-idle-seconds>0</max-idle-seconds>\n" + "        <eviction-policy>LRU</eviction-policy>\n" + "        <max-size policy=\"PER_NODE\">10</max-size>\n" + "        <eviction-percentage>50</eviction-percentage>\n" + "\n" + "        <merge-policy>com.hazelcast.map.merge.PassThroughMergePolicy</merge-policy>\n" + "\n" + "        <map-store enabled=\"true\">\n" + "            <class-name>com.hazelcast.client.map.helpers.AMapStore</class-name>\n" + "            <write-delay-seconds>5</write-delay-seconds>\n" + "        </map-store>\n" + "    </map>\n" + "\n" + "</hazelcast>";
        Config config = this.buildConfig(xml);
        HazelcastInstance hz = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap(mapNameWithStoreAndSize + "1");
        map.put((Object)1, (Object)1);
        MapStoreConfig mapStoreConfig = hz.getConfig().getMapConfig(mapNameWithStoreAndSize + "1").getMapStoreConfig();
        final AMapStore store = (AMapStore)mapStoreConfig.getImplementation();
        ClientMapStoreTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((Object)1, store.store.get(1));
            }
        });
    }

    private Config buildConfig(String xml) {
        ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes());
        XmlConfigBuilder configBuilder = new XmlConfigBuilder((InputStream)bis);
        return configBuilder.build();
    }

    public class MapStoreBackup
    implements MapStore<Object, Object> {
        public final Map<Object, Object> store = new ConcurrentHashMap<Object, Object>();

        public void store(Object key, Object value) {
            this.store.put(key, value);
        }

        public void storeAll(Map<Object, Object> map) {
            for (Map.Entry<Object, Object> kvp : map.entrySet()) {
                this.store.put(kvp.getKey(), kvp.getValue());
            }
        }

        public void delete(Object key) {
            this.store.remove(key);
        }

        public void deleteAll(Collection<Object> keys) {
            for (Object key : keys) {
                this.store.remove(key);
            }
        }

        public Object load(Object key) {
            return this.store.get(key);
        }

        public Map<Object, Object> loadAll(Collection<Object> keys) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Object key : keys) {
                Object v = this.store.get(key);
                if (v == null) continue;
                result.put(key, v);
            }
            return result;
        }

        public Set<Object> loadAllKeys() {
            return this.store.keySet();
        }
    }

    private class ClientThread
    extends Thread {
        IMap<String, String> map;

        private ClientThread() {
        }

        @Override
        public void run() {
            HazelcastInstance client = ClientMapStoreTest.this.hazelcastFactory.newHazelcastClient();
            this.map = client.getMap(ClientMapStoreTest.MAP_NAME);
            this.map.size();
        }
    }

    static class SimpleMapStore
    implements MapStore<String, String>,
    MapLoader<String, String> {
        static final int MAX_KEYS = 30;
        static final int DELAY_SECONDS_PER_KEY = 1;

        SimpleMapStore() {
        }

        public String load(String key) {
            HazelcastTestSupport.sleepSeconds((int)1);
            return key + "value";
        }

        public Map<String, String> loadAll(Collection<String> keys) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : keys) {
                map.put(key, this.load(key));
            }
            return map;
        }

        public Set<String> loadAllKeys() {
            HashSet<String> keys = new HashSet<String>();
            for (int i = 0; i < 30; ++i) {
                keys.add("key" + i);
            }
            return keys;
        }

        public void delete(String key) {
            HazelcastTestSupport.sleepSeconds((int)1);
        }

        public void deleteAll(Collection<String> keys) {
            for (String key : keys) {
                this.delete(key);
            }
        }

        public void store(String key, String value) {
            HazelcastTestSupport.sleepSeconds((int)1);
        }

        public void storeAll(Map<String, String> entries) {
            for (Map.Entry<String, String> e : entries.entrySet()) {
                this.store(e.getKey(), e.getValue());
            }
        }
    }
}

