/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.aggregation.Aggregators;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.AbstractEntryProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientPartitionPredicateTest
extends HazelcastTestSupport {
    private static final int PARTITIONS = 10;
    private static final int ITEMS_PER_PARTITION = 20;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance server;
    private HazelcastInstance client;
    private IMap<String, Integer> map;
    private String partitionKey;
    private int partitionId;
    private Predicate<String, Integer> predicate;

    @Before
    public void setUp() {
        Config config = this.getConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "10");
        this.server = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance remote = this.hazelcastFactory.newHazelcastInstance(config);
        ClientPartitionPredicateTest.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{this.server, remote});
        this.client = this.hazelcastFactory.newHazelcastClient();
        String mapName = ClientPartitionPredicateTest.randomString();
        this.map = this.client.getMap(mapName);
        for (int p = 0; p < 10; ++p) {
            for (int k = 0; k < 20; ++k) {
                this.map.put((Object)ClientPartitionPredicateTest.generateKeyForPartition((HazelcastInstance)this.server, (int)p), (Object)p);
            }
        }
        this.partitionKey = ClientPartitionPredicateTest.randomString();
        this.partitionId = this.server.getPartitionService().getPartition((Object)this.partitionKey).getPartitionId();
        this.predicate = new PartitionPredicate((Object)this.partitionKey, (Predicate)TruePredicate.INSTANCE);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void values() {
        Collection values = this.map.values(this.predicate);
        Assert.assertEquals((long)20L, (long)values.size());
        for (Integer value : values) {
            Assert.assertEquals((long)this.partitionId, (long)value.intValue());
        }
    }

    @Test
    public void keySet() {
        Set keys = this.map.keySet(this.predicate);
        Assert.assertEquals((long)20L, (long)keys.size());
        for (String key : keys) {
            Assert.assertEquals((long)this.partitionId, (long)this.server.getPartitionService().getPartition((Object)key).getPartitionId());
        }
    }

    @Test
    public void entries() {
        Set entries = this.map.entrySet(this.predicate);
        Assert.assertEquals((long)20L, (long)entries.size());
        for (Map.Entry entry : entries) {
            Assert.assertEquals((long)this.partitionId, (long)this.server.getPartitionService().getPartition(entry.getKey()).getPartitionId());
            Assert.assertEquals((long)this.partitionId, (long)((Integer)entry.getValue()).intValue());
        }
    }

    @Test
    public void aggregate() throws Exception {
        int partitionId = 2;
        String keyForPartition = ClientPartitionPredicateTest.generateKeyForPartition((HazelcastInstance)this.server, (int)partitionId);
        PartitionPredicate partitionPredicate = new PartitionPredicate((Object)keyForPartition, (Predicate)TruePredicate.INSTANCE);
        Long aggregate = (Long)this.map.aggregate(Aggregators.integerSum(), (Predicate)partitionPredicate);
        Long sum = partitionId * 20;
        Assert.assertEquals((Object)sum, (Object)aggregate);
    }

    @Test
    public void executeOnEntries() throws Exception {
        int partitionId = 2;
        String keyForPartition = ClientPartitionPredicateTest.generateKeyForPartition((HazelcastInstance)this.server, (int)partitionId);
        PartitionPredicate partitionPredicate = new PartitionPredicate((Object)keyForPartition, (Predicate)TruePredicate.INSTANCE);
        Map entries = this.map.executeOnEntries((EntryProcessor)new MyProcessor(), (Predicate)partitionPredicate);
        Assert.assertEquals((long)20L, (long)entries.size());
    }

    @Test
    public void project() throws Exception {
        PartitionPredicate partitionPredicate = new PartitionPredicate((Object)1, (Predicate)TruePredicate.INSTANCE);
        Collection collection = this.map.project((Projection)new PrimitiveValueIncrementingProjection(), (Predicate)partitionPredicate);
        Assert.assertEquals((long)20L, (long)collection.size());
    }

    public static class PrimitiveValueIncrementingProjection
    extends Projection<Map.Entry<String, Integer>, Integer> {
        public Integer transform(Map.Entry<String, Integer> input) {
            return input.getValue() + 1;
        }
    }

    static class MyProcessor
    extends AbstractEntryProcessor<String, Integer> {
        public Object process(Map.Entry<String, Integer> entry) {
            Integer in = entry.getValue();
            entry.setValue(in * 10);
            return entry;
        }
    }
}

