/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientNearCacheBatchInvalidationTest
extends ClientTestSupport {
    protected TestHazelcastFactory factory = new TestHazelcastFactory();
    protected String mapName = ClientNearCacheBatchInvalidationTest.randomMapName();

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void testBatchInvalidationRemovesEntries() {
        int i;
        Config config = this.getConfig();
        this.configureBatching(config, true, 10, 1);
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        ClientConfig clientConfig = this.newClientConfig(this.mapName);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.makeSureConnectedToServers(client, 2);
        IMap serverMap = server.getMap(this.mapName);
        IMap clientMap = client.getMap(this.mapName);
        int size = 1000;
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        for (i = 0; i < size; ++i) {
            clientMap.get((Object)i);
        }
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        this.assertNearCacheSizeEventually(clientMap, 0);
    }

    @Test
    public void testHigherBatchSize_shouldNotCauseAnyInvalidation_onClient() {
        int i;
        Config config = this.getConfig();
        this.configureBatching(config, true, Integer.MAX_VALUE, Integer.MAX_VALUE);
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        ClientConfig clientConfig = this.newClientConfig(this.mapName);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap serverMap = server.getMap(this.mapName);
        IMap clientMap = client.getMap(this.mapName);
        this.makeSureConnectedToServers(client, 2);
        int size = 1000;
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        for (i = 0; i < size; ++i) {
            clientMap.get((Object)i);
        }
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        this.assertNearCacheSizeEventually(clientMap, size);
    }

    @Test
    public void testMapClear_shouldClearNearCaches_onOwnerAndBackupNodes() {
        int i;
        Config config = this.getConfig();
        this.configureBatching(config, true, 10, 1);
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        ClientConfig clientConfig = this.newClientConfig(this.mapName);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap serverMap = server.getMap(this.mapName);
        IMap clientMap = client.getMap(this.mapName);
        this.makeSureConnectedToServers(client, 2);
        int size = 1000;
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        for (i = 0; i < size; ++i) {
            clientMap.get((Object)i);
        }
        serverMap.clear();
        this.assertNearCacheSizeEventually(clientMap, 0);
    }

    @Test
    public void testMapEvictAll_shouldClearNearCaches_onOwnerAndBackupNodes() {
        int i;
        Config config = this.getConfig();
        this.configureBatching(config, true, 10, 1);
        HazelcastInstance server = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        ClientConfig clientConfig = this.newClientConfig(this.mapName);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap serverMap = server.getMap(this.mapName);
        IMap clientMap = client.getMap(this.mapName);
        this.makeSureConnectedToServers(client, 2);
        int size = 1000;
        for (i = 0; i < size; ++i) {
            serverMap.put((Object)i, (Object)i);
        }
        for (i = 0; i < size; ++i) {
            clientMap.get((Object)i);
        }
        serverMap.evictAll();
        this.assertNearCacheSizeEventually(clientMap, 0);
    }

    protected ClientConfig newClientConfig(String mapName) {
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setInMemoryFormat(this.getNearCacheInMemoryFormat());
        nearCacheConfig.setName(mapName);
        nearCacheConfig.setInvalidateOnChange(true);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addNearCacheConfig(nearCacheConfig);
        return clientConfig;
    }

    private InMemoryFormat getNearCacheInMemoryFormat() {
        return InMemoryFormat.OBJECT;
    }

    private void configureBatching(Config config, boolean enableBatching, int batchSize, int period) {
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), String.valueOf(enableBatching));
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), String.valueOf(batchSize));
        config.setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), String.valueOf(period));
    }

    private void assertNearCacheSizeEventually(final IMap map, final int nearCacheSize) {
        ClientNearCacheBatchInvalidationTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                NearCache nearCache = ((NearCachedClientMapProxy)map).getNearCache();
                Assert.assertEquals((long)nearCacheSize, (long)nearCache.size());
            }
        });
    }
}

