/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class MapNearCacheInvalidationFromClientTest
extends HazelcastTestSupport {
    private String mapName;
    private TestHazelcastFactory factory;
    private HazelcastInstance lite;
    private HazelcastInstance client;

    @Before
    public void init() {
        this.mapName = MapNearCacheInvalidationFromClientTest.randomMapName();
        this.factory = new TestHazelcastFactory();
        this.factory.newHazelcastInstance(this.createServerConfig(this.mapName, false));
        this.lite = this.factory.newHazelcastInstance(this.createServerConfig(this.mapName, true));
        this.client = this.factory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void testPut() {
        IMap map = this.client.getMap(this.mapName);
        int count = 100;
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, (Object)i);
        }
        IMap liteMap = this.lite.getMap(this.mapName);
        for (int i = 0; i < count; ++i) {
            Assert.assertNotNull((Object)liteMap.get((Object)i));
        }
        NearCache<Object, Object> nearCache = this.getNearCache(this.lite, this.mapName);
        int sizeAfterPut = nearCache.size();
        Assert.assertTrue((String)("Near Cache size should be > 0 but was " + sizeAfterPut), (sizeAfterPut > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testClear() {
        IMap map = this.client.getMap(this.mapName);
        int count = 100;
        for (int i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)i);
        }
        final IMap liteMap = this.lite.getMap(this.mapName);
        final NearCache<Object, Object> nearCache = this.getNearCache(this.lite, this.mapName);
        MapNearCacheInvalidationFromClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                for (int i = 0; i < 100; ++i) {
                    liteMap.get((Object)i);
                }
                Assert.assertEquals((long)100L, (long)nearCache.size());
            }
        });
        map.clear();
        MapNearCacheInvalidationFromClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)0L, (long)nearCache.size());
            }
        });
    }

    @Test
    public void testEvictAll() {
        IMap map = this.client.getMap(this.mapName);
        int count = 100;
        for (int i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)i);
        }
        final IMap liteMap = this.lite.getMap(this.mapName);
        final NearCache<Object, Object> nearCache = this.getNearCache(this.lite, this.mapName);
        MapNearCacheInvalidationFromClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                for (int i = 0; i < 100; ++i) {
                    liteMap.get((Object)i);
                }
                Assert.assertEquals((long)100L, (long)nearCache.size());
            }
        });
        map.evictAll();
        MapNearCacheInvalidationFromClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((nearCache.size() < 100 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testEvict() {
        IMap map = this.client.getMap(this.mapName);
        int count = 100;
        for (int i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)i);
        }
        final IMap liteMap = this.lite.getMap(this.mapName);
        final NearCache<Object, Object> nearCache = this.getNearCache(this.lite, this.mapName);
        MapNearCacheInvalidationFromClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                for (int i = 0; i < 100; ++i) {
                    liteMap.get((Object)i);
                }
                Assert.assertEquals((long)100L, (long)nearCache.size());
            }
        });
        map.evict((Object)0);
        MapNearCacheInvalidationFromClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((nearCache.size() < 100 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testUpdate() {
        IMap map = this.client.getMap(this.mapName);
        map.put((Object)1, (Object)1);
        final IMap liteMap = this.lite.getMap(this.mapName);
        final NearCache<Object, Object> nearCache = this.getNearCache(this.lite, this.mapName);
        MapNearCacheInvalidationFromClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                liteMap.get((Object)1);
                Assert.assertEquals((Object)1, (Object)nearCache.get((Object)1));
            }
        });
        map.put((Object)1, (Object)2);
        MapNearCacheInvalidationFromClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertNull((Object)nearCache.get((Object)1));
            }
        });
    }

    @Test
    public void testRemove() {
        IMap map = this.client.getMap(this.mapName);
        map.put((Object)1, (Object)1);
        final IMap liteMap = this.lite.getMap(this.mapName);
        final NearCache<Object, Object> nearCache = this.getNearCache(this.lite, this.mapName);
        MapNearCacheInvalidationFromClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                liteMap.get((Object)1);
                Assert.assertEquals((Object)1, (Object)nearCache.get((Object)1));
            }
        });
        map.remove((Object)1);
        MapNearCacheInvalidationFromClientTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertNull((Object)nearCache.get((Object)1));
            }
        });
    }

    private Config createServerConfig(String mapName, boolean liteMember) {
        NearCacheConfig nearCacheConfig = new NearCacheConfig().setInvalidateOnChange(true);
        Config config = this.getConfig().setLiteMember(liteMember).setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true").setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), "5").setProperty(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), "1000");
        config.getMapConfig(mapName).setNearCacheConfig(nearCacheConfig);
        return config;
    }

    private NearCache<Object, Object> getNearCache(HazelcastInstance instance, String mapName) {
        MapServiceContext mapServiceContext = this.getMapService(instance).getMapServiceContext();
        MapNearCacheManager mapNearCacheManager = mapServiceContext.getMapNearCacheManager();
        NearCacheConfig nearCacheConfig = MapNearCacheInvalidationFromClientTest.getNodeEngineImpl((HazelcastInstance)instance).getConfig().getMapConfig(mapName).getNearCacheConfig();
        return mapNearCacheManager.getOrCreateNearCache(mapName, nearCacheConfig);
    }

    private MapService getMapService(HazelcastInstance instance) {
        return (MapService)MapNearCacheInvalidationFromClientTest.getNodeEngineImpl((HazelcastInstance)instance).getService("hz:impl:mapService");
    }
}

