/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.query;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.SampleTestObjects;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryAdvancedTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void queryIndexedComparableField_whenEqualsPredicateWithNullValueIsUsed_thenConverterUsesNullObject() {
        this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig());
        IMap map = client.getMap("default");
        map.addIndex("type", false);
        SampleTestObjects.ValueType valueType = new SampleTestObjects.ValueType("name");
        SampleTestObjects.Value valueWithoutNull = new SampleTestObjects.Value("notNull", valueType, 1);
        SampleTestObjects.Value valueWithNull = new SampleTestObjects.Value("null", null, 1);
        map.put((Object)1, (Object)valueWithoutNull);
        map.put((Object)2, (Object)valueWithNull);
        Predicate nullPredicate = Predicates.equal((String)"type", null);
        Collection emptyFieldValues = map.values(nullPredicate);
        Assert.assertThat((Object)emptyFieldValues, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)emptyFieldValues, (Matcher)Matchers.contains((Object[])new SampleTestObjects.Value[]{valueWithNull}));
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }
}

