/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.querycache;

import com.hazelcast.client.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.client.map.impl.querycache.subscriber.TestClientSubscriberContext;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EventLostEvent;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.listener.EventLostListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheEventLostListenerTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();
    private HazelcastInstance node;

    @Before
    public void setUp() {
        Config config = this.getConfig();
        config.setProperty(GroupProperty.PARTITION_COUNT.getName(), "1");
        this.node = this.factory.newHazelcastInstance(config);
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void testListenerNotified_onEventLoss() throws Exception {
        int count = 30;
        String mapName = ClientQueryCacheEventLostListenerTest.randomString();
        String queryCacheName = ClientQueryCacheEventLostListenerTest.randomString();
        IMap mapNode = this.node.getMap(mapName);
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap mapClient = client.getMap(mapName);
        this.setTestSequencer(mapClient, 9);
        final CountDownLatch lostEventCount = new CountDownLatch(1);
        QueryCache queryCache = mapClient.getQueryCache(queryCacheName, (Predicate)new SqlPredicate("this > 20"), true);
        queryCache.addEntryListener((MapListener)new EventLostListener(){

            public void eventLost(EventLostEvent event) {
                lostEventCount.countDown();
            }
        }, false);
        for (int i = 0; i < count; ++i) {
            mapNode.put((Object)i, (Object)i);
        }
        ClientQueryCacheEventLostListenerTest.assertOpenEventually((CountDownLatch)lostEventCount);
    }

    private void setTestSequencer(IMap map, int eventCount) {
        ClientMapProxy proxy = (ClientMapProxy)map;
        ClientQueryCacheContext queryCacheContext = proxy.getQueryCacheContext();
        queryCacheContext.setSubscriberContext((SubscriberContext)new TestClientSubscriberContext((QueryCacheContext)queryCacheContext, eventCount, true));
    }
}

