/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.mapreduce.aggregation;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Aggregations;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
@Ignore
public class MultiMapAggregationLiteMemberTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory;
    private HazelcastInstance client;

    @Before
    public void before() {
        this.factory = new TestHazelcastFactory();
        HazelcastInstance lite = this.factory.newHazelcastInstance(new Config().setLiteMember(true));
        HazelcastInstance instance1 = this.factory.newHazelcastInstance();
        HazelcastInstance instance2 = this.factory.newHazelcastInstance();
        MultiMapAggregationLiteMemberTest.assertClusterSize((int)3, (HazelcastInstance[])new HazelcastInstance[]{lite, instance2});
        MultiMapAggregationLiteMemberTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{instance1});
        this.client = this.factory.newHazelcastClient();
    }

    @After
    public void after() {
        this.factory.terminateAll();
    }

    @Test(timeout=60000L)
    public void testMaxAggregation() {
        MultiMapAggregationLiteMemberTest.testMaxAggregation(this.client);
    }

    public static void testMaxAggregation(HazelcastInstance instance) {
        int size = 2000;
        List numbers = new ArrayList<Integer>(2000);
        for (int i = 0; i < 2000; ++i) {
            numbers.add(i);
        }
        Collections.shuffle(numbers);
        numbers = numbers.subList(0, 1000);
        Integer expected = (Integer)Collections.max(numbers);
        MultiMap map = instance.getMultiMap(MultiMapAggregationLiteMemberTest.randomMapName());
        for (Integer number : numbers) {
            map.put((Object)(number / 2), (Object)number);
        }
        Aggregation maxAggregation = Aggregations.integerMax();
        Integer max = (Integer)map.aggregate((Supplier)new ValueSupplier(), maxAggregation);
        Assert.assertEquals((Object)expected, (Object)max);
    }

    public static class ValueSupplier
    extends Supplier<Integer, Integer, Integer>
    implements Serializable {
        public Integer apply(Map.Entry<Integer, Integer> entry) {
            return entry.getValue();
        }
    }
}

