/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.multimap;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMultiMapReturnedCollectionTest {
    private static final String SET_MAP = "set-map";
    private static final String LIST_MAP = "list-map";
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        Config config = new Config();
        config.getMultiMapConfig(SET_MAP).setValueCollectionType(MultiMapConfig.ValueCollectionType.SET);
        config.getMultiMapConfig(LIST_MAP).setValueCollectionType(MultiMapConfig.ValueCollectionType.LIST);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testGet_withSetBackedValueCollection() throws Exception {
        MultiMap multiMap = this.client.getMultiMap(SET_MAP);
        multiMap.put((Object)0, (Object)1);
        multiMap.put((Object)0, (Object)1);
        multiMap.put((Object)0, (Object)2);
        Collection collection = multiMap.get((Object)0);
        Assert.assertEquals((long)2L, (long)collection.size());
    }

    @Test
    public void testGet_withSetBackedValueCollection_onEmptyMultiMap() throws Exception {
        MultiMap multiMap = this.client.getMultiMap(SET_MAP);
        Collection collection = multiMap.get((Object)0);
        Assert.assertEquals((long)0L, (long)collection.size());
    }

    @Test
    public void testGet_withListBackedValueCollection() throws Exception {
        MultiMap multiMap = this.client.getMultiMap(LIST_MAP);
        multiMap.put((Object)0, (Object)1);
        multiMap.put((Object)0, (Object)1);
        multiMap.put((Object)0, (Object)2);
        Collection collection = multiMap.get((Object)0);
        Assert.assertEquals((long)3L, (long)collection.size());
    }

    @Test
    public void testGet_withListBackedValueCollection_onEmptyMultiMap() throws Exception {
        MultiMap multiMap = this.client.getMultiMap(LIST_MAP);
        Collection collection = multiMap.get((Object)0);
        Assert.assertEquals((long)0L, (long)collection.size());
    }

    @Test
    public void testRemove_withSetBackedValueCollection() throws Exception {
        MultiMap multiMap = this.client.getMultiMap(SET_MAP);
        multiMap.put((Object)0, (Object)1);
        multiMap.put((Object)0, (Object)1);
        multiMap.put((Object)0, (Object)2);
        Collection collection = multiMap.remove((Object)0);
        Assert.assertEquals((long)2L, (long)collection.size());
    }

    @Test
    public void testRemove_withSetBackedValueCollection_onEmptyMultiMap() throws Exception {
        MultiMap multiMap = this.client.getMultiMap(SET_MAP);
        Collection collection = multiMap.remove((Object)0);
        Assert.assertEquals((long)0L, (long)collection.size());
    }

    @Test
    public void testRemove_withListBackedValueCollection() throws Exception {
        MultiMap multiMap = this.client.getMultiMap(LIST_MAP);
        multiMap.put((Object)0, (Object)1);
        multiMap.put((Object)0, (Object)1);
        multiMap.put((Object)0, (Object)2);
        Collection collection = multiMap.remove((Object)0);
        Assert.assertEquals((long)3L, (long)collection.size());
    }

    @Test
    public void testRemove_withListBackedValueCollection_onEmptyMultiMap() throws Exception {
        MultiMap multiMap = this.client.getMultiMap(LIST_MAP);
        Collection collection = multiMap.remove((Object)0);
        Assert.assertEquals((long)0L, (long)collection.size());
    }
}

