/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.partitionservice;

import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientPartitionServiceLiteMemberTest {
    private TestHazelcastFactory factory;

    @Before
    public void before() {
        this.factory = new TestHazelcastFactory();
    }

    @After
    public void after() {
        this.factory.terminateAll();
    }

    @Test(expected=NoDataMemberInClusterException.class)
    public void testGetPartitionsBlockingFailWithOnlyLiteMember() {
        this.factory.newHazelcastInstance(new Config().setLiteMember(true));
        HazelcastInstance client = this.factory.newHazelcastClient();
        ClientPartitionService clientPartitionService = this.getClientPartitionService(client);
        clientPartitionService.getPartitionOwner(0);
    }

    @Test
    public void testPartitionsBlockingSucceedsWithLiteMemberAndDataMember() {
        this.factory.newHazelcastInstance();
        this.factory.newHazelcastInstance(new Config().setLiteMember(true));
        HazelcastInstance client = this.factory.newHazelcastClient();
        ClientPartitionService clientPartitionService = this.getClientPartitionService(client);
        Assert.assertNotNull((Object)clientPartitionService.getPartitionOwner(0));
    }

    private ClientPartitionService getClientPartitionService(HazelcastInstance client) {
        return ClientTestUtil.getHazelcastClientInstanceImpl(client).getClientPartitionService();
    }
}

