/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class DistributedObjectListenerTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void destroyedNotReceivedOnClient() throws Exception {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        final HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        final CountDownLatch createdLatch = new CountDownLatch(1);
        final CountDownLatch destroyedLatch = new CountDownLatch(1);
        client.addDistributedObjectListener(new DistributedObjectListener(){

            public void distributedObjectCreated(DistributedObjectEvent event) {
                createdLatch.countDown();
            }

            public void distributedObjectDestroyed(DistributedObjectEvent event) {
                destroyedLatch.countDown();
            }
        });
        String name = DistributedObjectListenerTest.randomString();
        ITopic topic = instance.getTopic(name);
        DistributedObjectListenerTest.assertOpenEventually((CountDownLatch)createdLatch, (long)10L);
        Assert.assertEquals((long)1L, (long)client.getDistributedObjects().size());
        topic.destroy();
        DistributedObjectListenerTest.assertOpenEventually((CountDownLatch)destroyedLatch, (long)10L);
        DistributedObjectListenerTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Collection distributedObjects = client.getDistributedObjects();
                Assert.assertTrue((boolean)distributedObjects.isEmpty());
            }
        }, (long)5L);
    }

    @Test
    public void testGetDistributedObjectsAfterRemove_FromNode() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        IMap firstMap = server.getMap("firstMap");
        server.getMap("secondMap");
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        Assert.assertEquals((long)2L, (long)client.getDistributedObjects().size());
        firstMap.destroy();
        Assert.assertEquals((long)1L, (long)client.getDistributedObjects().size());
    }

    @Test
    public void testGetDistributedObjectsAfterRemove_fromClient() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client1 = this.hazelcastFactory.newHazelcastClient();
        IMap firstMap = client1.getMap("firstMap");
        client1.getMap("secondMap");
        HazelcastInstance client2 = this.hazelcastFactory.newHazelcastClient();
        Assert.assertEquals((long)2L, (long)client1.getDistributedObjects().size());
        Assert.assertEquals((long)2L, (long)client2.getDistributedObjects().size());
        firstMap.destroy();
        Assert.assertEquals((long)1L, (long)client1.getDistributedObjects().size());
        Assert.assertEquals((long)1L, (long)client2.getDistributedObjects().size());
    }
}

