/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.nio.Address;
import com.hazelcast.replicatedmap.ReplicatedMapCantBeCreatedOnLiteMemberException;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientReplicatedMapLiteMemberTest {
    private TestHazelcastFactory factory;
    private ClientConfig smartClientConfig;
    private ClientConfig dummyClientConfig;

    @Before
    public void init() {
        this.factory = new TestHazelcastFactory();
        this.smartClientConfig = new ClientConfig();
        this.dummyClientConfig = new ClientConfig();
        this.dummyClientConfig.getNetworkConfig().setSmartRouting(false);
    }

    @After
    public void destroy() {
        this.factory.terminateAll();
    }

    @Test
    public void testReplicatedMapIsCreatedBySmartClient() {
        this.testReplicatedMapCreated(2, 1, this.smartClientConfig);
    }

    @Test
    public void testReplicatedMapIsCreatedByDummyClient() {
        this.testReplicatedMapCreated(2, 1, this.dummyClientConfig);
    }

    @Test(expected=ReplicatedMapCantBeCreatedOnLiteMemberException.class)
    public void testReplicatedMapNotCreatedOnOnlyLiteMembersBySmartClient() {
        this.testReplicatedMapCreated(2, 0, this.smartClientConfig);
    }

    @Test(expected=ReplicatedMapCantBeCreatedOnLiteMemberException.class)
    public void testReplicatedMapNotCreatedOnOnlyLiteMembersByDummyClient() {
        this.testReplicatedMapCreated(2, 0, this.dummyClientConfig);
    }

    @Test(expected=ReplicatedMapCantBeCreatedOnLiteMemberException.class)
    public void testReplicatedMapNotCreatedOnSingleLiteMemberBySmartClient() {
        this.testReplicatedMapCreated(1, 0, this.smartClientConfig);
    }

    @Test(expected=ReplicatedMapCantBeCreatedOnLiteMemberException.class)
    public void testReplicatedMapNotCreatedOnSingleLiteMemberByDummyClient() {
        this.testReplicatedMapCreated(1, 0, this.dummyClientConfig);
    }

    private void testReplicatedMapCreated(int numberOfLiteNodes, int numberOfDataNodes, ClientConfig clientConfig) {
        this.createNodes(numberOfLiteNodes, numberOfDataNodes);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        Assert.assertNotNull((Object)client.getReplicatedMap(HazelcastTestSupport.randomMapName()));
    }

    @Test
    public void testReplicatedMapPutBySmartClient() {
        this.createNodes(3, 1);
        HazelcastInstance client = this.factory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(HazelcastTestSupport.randomMapName());
        Assert.assertNull((Object)map.put((Object)1, (Object)2));
    }

    @Test
    public void testReplicatedMapPutByDummyClient() throws UnknownHostException {
        List<HazelcastInstance> instances = this.createNodes(3, 1);
        this.configureDummyClientConnection(instances.get(0));
        HazelcastInstance client = this.factory.newHazelcastClient(this.dummyClientConfig);
        ReplicatedMap map = client.getReplicatedMap(HazelcastTestSupport.randomMapName());
        map.put((Object)1, (Object)2);
    }

    private void configureDummyClientConnection(HazelcastInstance instance) throws UnknownHostException {
        Address memberAddress = HazelcastTestSupport.getAddress((HazelcastInstance)instance);
        this.dummyClientConfig.setProperty(ClientProperty.SHUFFLE_MEMBER_LIST.getName(), "false");
        ClientNetworkConfig networkConfig = this.dummyClientConfig.getNetworkConfig();
        networkConfig.addAddress(new String[]{memberAddress.getHost() + ":" + memberAddress.getPort()});
    }

    private List<HazelcastInstance> createNodes(int numberOfLiteNodes, int numberOfDataNodes) {
        int i;
        ArrayList<HazelcastInstance> instances = new ArrayList<HazelcastInstance>();
        Config liteConfig = new Config().setLiteMember(true);
        for (i = 0; i < numberOfLiteNodes; ++i) {
            instances.add(this.factory.newHazelcastInstance(liteConfig));
        }
        for (i = 0; i < numberOfDataNodes; ++i) {
            instances.add(this.factory.newHazelcastInstance());
        }
        int clusterSize = numberOfLiteNodes + numberOfDataNodes;
        for (HazelcastInstance instance : instances) {
            HazelcastTestSupport.assertClusterSizeEventually((int)clusterSize, (HazelcastInstance[])new HazelcastInstance[]{instance});
        }
        return instances;
    }
}

