/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientReplicatedMapPutSerializationTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();
    private static AtomicInteger deSerializationCount = new AtomicInteger(0);

    @After
    public void tearDown() {
        this.factory.terminateAll();
    }

    @Test
    public void testPutShouldNotDeserializeData() {
        String mapName = ClientReplicatedMapPutSerializationTest.randomName();
        Config config = new Config();
        config.getReplicatedMapConfig(mapName).setInMemoryFormat(InMemoryFormat.BINARY);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(mapName);
        String key = ClientReplicatedMapPutSerializationTest.randomString();
        SerializationCountingData value = new SerializationCountingData();
        map.put((Object)key, (Object)value);
        map.put((Object)key, (Object)value);
        Assert.assertEquals((long)1L, (long)deSerializationCount.get());
    }

    static class SerializationCountingData
    implements DataSerializable {
        public void writeData(ObjectDataOutput out) throws IOException {
        }

        public void readData(ObjectDataInput in) throws IOException {
            deSerializationCount.incrementAndGet();
        }
    }
}

