/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap.nearcache;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.proxy.ClientReplicatedMapProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.internal.nearcache.NearCacheInvalidationListener;
import com.hazelcast.nio.serialization.Data;
import java.util.concurrent.atomic.AtomicLong;

class ClientReplicatedMapInvalidationListener
extends ReplicatedMapAddNearCacheEntryListenerCodec.AbstractEventHandler
implements NearCacheInvalidationListener,
EventHandler<ClientMessage> {
    private final AtomicLong invalidationCount = new AtomicLong();
    private final ReplicatedMap clientMap;

    private ClientReplicatedMapInvalidationListener(ReplicatedMap clientMap) {
        this.clientMap = clientMap;
    }

    public long getInvalidationCount() {
        return this.invalidationCount.get();
    }

    public void resetInvalidationCount() {
        this.invalidationCount.set(0L);
    }

    public void handle(Data dataKey, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
        EntryEventType entryEventType = EntryEventType.getByType((int)eventType);
        switch (entryEventType) {
            case ADDED: 
            case REMOVED: 
            case UPDATED: 
            case EVICTED: {
                this.invalidationCount.incrementAndGet();
                break;
            }
            case CLEAR_ALL: {
                this.invalidationCount.addAndGet(this.clientMap.size());
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a known event type " + entryEventType);
            }
        }
    }

    public void beforeListenerRegister() {
    }

    public void onListenerRegister() {
    }

    static NearCacheInvalidationListener createInvalidationEventHandler(ReplicatedMap clientMap) {
        ClientReplicatedMapInvalidationListener invalidationListener = new ClientReplicatedMapInvalidationListener(clientMap);
        ((ClientReplicatedMapProxy)clientMap).addNearCacheInvalidationListener((EventHandler)invalidationListener);
        return invalidationListener;
    }
}

