/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientClasspathXmlConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.spi.impl.discovery.DiscoveryAddressTranslator;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.config.properties.PropertyTypeConverter;
import com.hazelcast.config.properties.SimplePropertyDefinition;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.TypeConverter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.hazelcast.spi.discovery.NodeFilter;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.spi.discovery.impl.DefaultDiscoveryService;
import com.hazelcast.spi.discovery.impl.DefaultDiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryMode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceSettings;
import com.hazelcast.spi.partitiongroup.PartitionGroupStrategy;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientDiscoverySpiTest
extends HazelcastTestSupport {
    private static final ILogger LOGGER = Logger.getLogger(ClientDiscoverySpiTest.class);

    @After
    public void cleanup() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testSchema() throws Exception {
        String xmlFileName = "hazelcast-client-discovery-spi-test.xml";
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaResource = ClientDiscoverySpiTest.class.getClassLoader().getResource("hazelcast-client-config-3.10.xsd");
        Schema schema = factory.newSchema(schemaResource);
        InputStream xmlResource = ClientDiscoverySpiTest.class.getClassLoader().getResourceAsStream(xmlFileName);
        StreamSource source = new StreamSource(xmlResource);
        Validator validator = schema.newValidator();
        validator.validate(source);
    }

    @Test
    public void testParsing() {
        String xmlFileName = "hazelcast-client-discovery-spi-test.xml";
        InputStream xmlResource = ClientDiscoverySpiTest.class.getClassLoader().getResourceAsStream(xmlFileName);
        ClientConfig clientConfig = new XmlClientConfigBuilder(xmlResource).build();
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        ClientAwsConfig awsConfig = networkConfig.getAwsConfig();
        Assert.assertNull((Object)awsConfig);
        DiscoveryConfig discoveryConfig = networkConfig.getDiscoveryConfig();
        Assert.assertTrue((boolean)discoveryConfig.isEnabled());
        Assert.assertEquals((long)1L, (long)discoveryConfig.getDiscoveryStrategyConfigs().size());
        DiscoveryStrategyConfig providerConfig = (DiscoveryStrategyConfig)discoveryConfig.getDiscoveryStrategyConfigs().iterator().next();
        Assert.assertEquals((long)3L, (long)providerConfig.getProperties().size());
        Assert.assertEquals((Object)"foo", providerConfig.getProperties().get("key-string"));
        Assert.assertEquals((Object)"123", providerConfig.getProperties().get("key-int"));
        Assert.assertEquals((Object)"true", providerConfig.getProperties().get("key-boolean"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeStartup() {
        Config config = new Config();
        config.setProperty("hazelcast.discovery.enabled", "true");
        config.getNetworkConfig().setPort(50001);
        InterfacesConfig interfaces = config.getNetworkConfig().getInterfaces();
        interfaces.clear();
        interfaces.setEnabled(true);
        interfaces.addInterface("127.0.0.1");
        CopyOnWriteArrayList discoveryNodes = new CopyOnWriteArrayList();
        CollectingDiscoveryStrategyFactory factory = new CollectingDiscoveryStrategyFactory(discoveryNodes);
        JoinConfig join = config.getNetworkConfig().getJoin();
        join.getTcpIpConfig().setEnabled(false);
        join.getMulticastConfig().setEnabled(false);
        DiscoveryConfig discoveryConfig = join.getDiscoveryConfig();
        discoveryConfig.getDiscoveryStrategyConfigs().clear();
        DiscoveryStrategyConfig strategyConfig = new DiscoveryStrategyConfig((DiscoveryStrategyFactory)factory, Collections.emptyMap());
        discoveryConfig.addDiscoveryStrategyConfig(strategyConfig);
        HazelcastInstance hazelcastInstance1 = Hazelcast.newHazelcastInstance((Config)config);
        HazelcastInstance hazelcastInstance2 = Hazelcast.newHazelcastInstance((Config)config);
        HazelcastInstance hazelcastInstance3 = Hazelcast.newHazelcastInstance((Config)config);
        try {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.setProperty("hazelcast.discovery.enabled", "true");
            discoveryConfig = clientConfig.getNetworkConfig().getDiscoveryConfig();
            discoveryConfig.getDiscoveryStrategyConfigs().clear();
            strategyConfig = new DiscoveryStrategyConfig((DiscoveryStrategyFactory)factory, Collections.emptyMap());
            discoveryConfig.addDiscoveryStrategyConfig(strategyConfig);
            HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
            Assert.assertNotNull((Object)hazelcastInstance1);
            Assert.assertNotNull((Object)hazelcastInstance2);
            Assert.assertNotNull((Object)hazelcastInstance3);
            Assert.assertNotNull((Object)client);
            ClientDiscoverySpiTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{hazelcastInstance1, hazelcastInstance2, hazelcastInstance3, client});
        }
        finally {
            HazelcastClient.shutdownAll();
            Hazelcast.shutdownAll();
        }
    }

    @Test
    public void testDiscoveryServiceLifecycleMethodsCalledWhenClientAndServerStartAndShutdown() {
        Config config = new Config();
        config.setProperty("hazelcast.discovery.enabled", "true");
        config.getNetworkConfig().setPort(50001);
        InterfacesConfig interfaces = config.getNetworkConfig().getInterfaces();
        interfaces.clear();
        interfaces.setEnabled(true);
        interfaces.addInterface("127.0.0.1");
        CountDownLatch startLatch = new CountDownLatch(2);
        CountDownLatch stopLatch = new CountDownLatch(2);
        CopyOnWriteArrayList discoveryNodes = new CopyOnWriteArrayList();
        LifecycleDiscoveryStrategyFactory factory = new LifecycleDiscoveryStrategyFactory(startLatch, stopLatch, discoveryNodes);
        JoinConfig join = config.getNetworkConfig().getJoin();
        join.getTcpIpConfig().setEnabled(false);
        join.getMulticastConfig().setEnabled(false);
        DiscoveryConfig discoveryConfig = join.getDiscoveryConfig();
        discoveryConfig.getDiscoveryStrategyConfigs().clear();
        DiscoveryStrategyConfig strategyConfig = new DiscoveryStrategyConfig((DiscoveryStrategyFactory)factory, Collections.emptyMap());
        discoveryConfig.addDiscoveryStrategyConfig(strategyConfig);
        HazelcastInstance hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.discovery.enabled", "true");
        discoveryConfig = clientConfig.getNetworkConfig().getDiscoveryConfig();
        discoveryConfig.getDiscoveryStrategyConfigs().clear();
        strategyConfig = new DiscoveryStrategyConfig((DiscoveryStrategyFactory)factory, Collections.emptyMap());
        discoveryConfig.addDiscoveryStrategyConfig(strategyConfig);
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        Assert.assertNotNull((Object)hazelcastInstance);
        Assert.assertNotNull((Object)client);
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
        ClientDiscoverySpiTest.assertOpenEventually((CountDownLatch)startLatch);
        ClientDiscoverySpiTest.assertOpenEventually((CountDownLatch)stopLatch);
    }

    @Test
    public void testNodeFilter_from_xml() throws Exception {
        String xmlFileName = "hazelcast-client-discovery-spi-test.xml";
        InputStream xmlResource = ClientDiscoverySpiTest.class.getClassLoader().getResourceAsStream(xmlFileName);
        ClientConfig clientConfig = new XmlClientConfigBuilder(xmlResource).build();
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        DiscoveryConfig discoveryConfig = networkConfig.getDiscoveryConfig();
        DefaultDiscoveryServiceProvider provider = new DefaultDiscoveryServiceProvider();
        DiscoveryService discoveryService = provider.newDiscoveryService(this.buildDiscoveryServiceSettings(discoveryConfig));
        discoveryService.start();
        discoveryService.discoverNodes();
        discoveryService.destroy();
        Field nodeFilterField = DefaultDiscoveryService.class.getDeclaredField("nodeFilter");
        nodeFilterField.setAccessible(true);
        TestNodeFilter nodeFilter = (TestNodeFilter)nodeFilterField.get(discoveryService);
        Assert.assertEquals((long)4L, (long)nodeFilter.getNodes().size());
    }

    @Test
    public void test_discovery_address_translator() throws Exception {
        String xmlFileName = "hazelcast-client-discovery-spi-test.xml";
        InputStream xmlResource = ClientDiscoverySpiTest.class.getClassLoader().getResourceAsStream(xmlFileName);
        ClientConfig clientConfig = new XmlClientConfigBuilder(xmlResource).build();
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        DiscoveryConfig discoveryConfig = networkConfig.getDiscoveryConfig();
        DefaultDiscoveryServiceProvider provider = new DefaultDiscoveryServiceProvider();
        DiscoveryService discoveryService = provider.newDiscoveryService(this.buildDiscoveryServiceSettings(discoveryConfig));
        DiscoveryAddressTranslator translator = new DiscoveryAddressTranslator(discoveryService, false);
        Address address = new Address("127.0.0.1", 50001);
        Assert.assertNull((Object)translator.translate(null));
        Assert.assertEquals((Object)address, (Object)translator.translate(address));
        Assert.assertEquals((Object)address, (Object)translator.translate(address));
    }

    @Test
    public void test_discovery_address_translator_with_public_ip() throws Exception {
        String xmlFileName = "hazelcast-client-discovery-spi-test.xml";
        InputStream xmlResource = ClientDiscoverySpiTest.class.getClassLoader().getResourceAsStream(xmlFileName);
        ClientConfig clientConfig = new XmlClientConfigBuilder(xmlResource).build();
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        DiscoveryConfig discoveryConfig = networkConfig.getDiscoveryConfig();
        DefaultDiscoveryServiceProvider provider = new DefaultDiscoveryServiceProvider();
        DiscoveryService discoveryService = provider.newDiscoveryService(this.buildDiscoveryServiceSettings(discoveryConfig));
        DiscoveryAddressTranslator translator = new DiscoveryAddressTranslator(discoveryService, true);
        Address publicAddress = new Address("127.0.0.1", 50001);
        Address privateAddress = new Address("127.0.0.1", 1);
        Assert.assertEquals((Object)publicAddress, (Object)translator.translate(privateAddress));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_enabled_whenDiscoveryConfigIsNull() {
        ClientConfig config = new ClientConfig();
        config.setProperty(GroupProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        networkConfig.setDiscoveryConfig(null);
    }

    @Test
    public void test_enabled_whenDiscoveryConfigIsEmpty() {
        ClientConfig config = new ClientConfig();
        config.setProperty(GroupProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        networkConfig.setConnectionAttemptLimit(1);
        networkConfig.setConnectionAttemptPeriod(1);
        try {
            HazelcastClient.newHazelcastClient((ClientConfig)config);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_CustomDiscoveryService_whenDiscoveredNodes_isNull() {
        ClientConfig config = new ClientConfig();
        config.setProperty(GroupProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
        final DiscoveryService discoveryService = (DiscoveryService)Mockito.mock(DiscoveryService.class);
        DiscoveryServiceProvider discoveryServiceProvider = new DiscoveryServiceProvider(){

            public DiscoveryService newDiscoveryService(DiscoveryServiceSettings arg0) {
                return discoveryService;
            }
        };
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        networkConfig.setConnectionAttemptLimit(1);
        networkConfig.setConnectionAttemptPeriod(1);
        networkConfig.getDiscoveryConfig().setDiscoveryServiceProvider(discoveryServiceProvider);
        try {
            HazelcastClient.newHazelcastClient((ClientConfig)config);
            Assert.fail((String)"Client cannot start, discovery nodes is null!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ((DiscoveryService)Mockito.verify((Object)discoveryService)).discoverNodes();
    }

    @Test
    public void test_CustomDiscoveryService_whenDiscoveredNodes_isEmpty() {
        ClientConfig config = new ClientConfig();
        config.setProperty(GroupProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
        final DiscoveryService discoveryService = (DiscoveryService)Mockito.mock(DiscoveryService.class);
        DiscoveryServiceProvider discoveryServiceProvider = new DiscoveryServiceProvider(){

            public DiscoveryService newDiscoveryService(DiscoveryServiceSettings arg0) {
                Mockito.when((Object)discoveryService.discoverNodes()).thenReturn(Collections.emptyList());
                return discoveryService;
            }
        };
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        networkConfig.setConnectionAttemptLimit(1);
        networkConfig.setConnectionAttemptPeriod(1);
        networkConfig.getDiscoveryConfig().setDiscoveryServiceProvider(discoveryServiceProvider);
        try {
            HazelcastClient.newHazelcastClient((ClientConfig)config);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((DiscoveryService)Mockito.verify((Object)discoveryService)).discoverNodes();
    }

    @Test(expected=IllegalStateException.class)
    public void testDiscoveryEnabledNoLocalhost() {
        Hazelcast.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(GroupProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        networkConfig.setConnectionAttemptLimit(1);
        networkConfig.setConnectionAttemptPeriod(1);
        networkConfig.getDiscoveryConfig().addDiscoveryStrategyConfig(new DiscoveryStrategyConfig((DiscoveryStrategyFactory)new NoMemberDiscoveryStrategyFactory(), Collections.emptyMap()));
        HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    @Test
    public void testDiscoveryDisabledLocalhost() {
        Hazelcast.newHazelcastInstance();
        HazelcastClient.newHazelcastClient();
    }

    @Test(expected=IllegalStateException.class)
    public void testMulticastDiscoveryEnabledNoLocalhost() {
        Hazelcast.newHazelcastInstance();
        ClientClasspathXmlConfig clientConfig = new ClientClasspathXmlConfig("hazelcast-client-dummy-multicast-discovery-test.xml");
        HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    private DiscoveryServiceSettings buildDiscoveryServiceSettings(DiscoveryConfig config) {
        return new DiscoveryServiceSettings().setConfigClassLoader(ClientDiscoverySpiTest.class.getClassLoader()).setDiscoveryConfig(config).setDiscoveryMode(DiscoveryMode.Client).setLogger(LOGGER);
    }

    public static class NoMemberDiscoveryStrategyFactory
    implements DiscoveryStrategyFactory {
        public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
            return NoMemberDiscoveryStrategy.class;
        }

        public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
            return new NoMemberDiscoveryStrategy(logger, properties);
        }

        public Collection<PropertyDefinition> getConfigurationProperties() {
            return null;
        }
    }

    private static class NoMemberDiscoveryStrategy
    extends AbstractDiscoveryStrategy {
        public NoMemberDiscoveryStrategy(ILogger logger, Map<String, Comparable> properties) {
            super(logger, properties);
        }

        public Iterable<DiscoveryNode> discoverNodes() {
            return null;
        }
    }

    public static class TestNodeFilter
    implements NodeFilter {
        private final List<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();

        public boolean test(DiscoveryNode candidate) {
            this.nodes.add(candidate);
            return true;
        }

        private List<DiscoveryNode> getNodes() {
            return this.nodes;
        }
    }

    private static class LifecycleDiscoveryStrategy
    extends AbstractDiscoveryStrategy {
        private final CountDownLatch startLatch;
        private final CountDownLatch stopLatch;
        private final List<DiscoveryNode> discoveryNodes;
        private final DiscoveryNode discoveryNode;

        public LifecycleDiscoveryStrategy(CountDownLatch startLatch, CountDownLatch stopLatch, DiscoveryNode discoveryNode, List<DiscoveryNode> discoveryNodes, ILogger logger, Map<String, Comparable> properties) {
            super(logger, properties);
            this.startLatch = startLatch;
            this.stopLatch = stopLatch;
            this.discoveryNodes = discoveryNodes;
            this.discoveryNode = discoveryNode;
        }

        public void start() {
            super.start();
            this.startLatch.countDown();
            if (this.discoveryNode != null) {
                this.discoveryNodes.add(this.discoveryNode);
            }
        }

        public Iterable<DiscoveryNode> discoverNodes() {
            return new ArrayList<DiscoveryNode>(this.discoveryNodes);
        }

        public void destroy() {
            super.destroy();
            this.stopLatch.countDown();
            this.discoveryNodes.remove(this.discoveryNode);
        }
    }

    public static class LifecycleDiscoveryStrategyFactory
    implements DiscoveryStrategyFactory {
        private final CountDownLatch startLatch;
        private final CountDownLatch stopLatch;
        private final List<DiscoveryNode> discoveryNodes;

        private LifecycleDiscoveryStrategyFactory(CountDownLatch startLatch, CountDownLatch stopLatch, List<DiscoveryNode> discoveryNodes) {
            this.startLatch = startLatch;
            this.stopLatch = stopLatch;
            this.discoveryNodes = discoveryNodes;
        }

        public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
            return LifecycleDiscoveryStrategy.class;
        }

        public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
            return new LifecycleDiscoveryStrategy(this.startLatch, this.stopLatch, discoveryNode, this.discoveryNodes, logger, properties);
        }

        public Collection<PropertyDefinition> getConfigurationProperties() {
            return null;
        }
    }

    private static class CollectingDiscoveryStrategy
    extends AbstractDiscoveryStrategy {
        private final List<DiscoveryNode> discoveryNodes;
        private final DiscoveryNode discoveryNode;

        public CollectingDiscoveryStrategy(DiscoveryNode discoveryNode, List<DiscoveryNode> discoveryNodes, ILogger logger, Map<String, Comparable> properties) {
            super(logger, properties);
            this.discoveryNodes = discoveryNodes;
            this.discoveryNode = discoveryNode;
        }

        public void start() {
            super.start();
            if (this.discoveryNode != null) {
                this.discoveryNodes.add(this.discoveryNode);
            }
            this.getLogger();
            this.getProperties();
        }

        public Iterable<DiscoveryNode> discoverNodes() {
            return new ArrayList<DiscoveryNode>(this.discoveryNodes);
        }

        public void destroy() {
            super.destroy();
            this.discoveryNodes.remove(this.discoveryNode);
        }
    }

    public static class CollectingDiscoveryStrategyFactory
    implements DiscoveryStrategyFactory {
        private final List<DiscoveryNode> discoveryNodes;

        private CollectingDiscoveryStrategyFactory(List<DiscoveryNode> discoveryNodes) {
            this.discoveryNodes = discoveryNodes;
        }

        public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
            return CollectingDiscoveryStrategy.class;
        }

        public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
            return new CollectingDiscoveryStrategy(discoveryNode, this.discoveryNodes, logger, properties);
        }

        public Collection<PropertyDefinition> getConfigurationProperties() {
            return null;
        }
    }

    public static class TestDiscoveryStrategyFactory
    implements DiscoveryStrategyFactory {
        private final Collection<PropertyDefinition> propertyDefinitions;

        public TestDiscoveryStrategyFactory() {
            ArrayList<SimplePropertyDefinition> propertyDefinitions = new ArrayList<SimplePropertyDefinition>();
            propertyDefinitions.add(new SimplePropertyDefinition("key-string", (TypeConverter)PropertyTypeConverter.STRING));
            propertyDefinitions.add(new SimplePropertyDefinition("key-int", (TypeConverter)PropertyTypeConverter.INTEGER));
            propertyDefinitions.add(new SimplePropertyDefinition("key-boolean", (TypeConverter)PropertyTypeConverter.BOOLEAN));
            propertyDefinitions.add(new SimplePropertyDefinition("key-something", true, (TypeConverter)PropertyTypeConverter.STRING));
            this.propertyDefinitions = Collections.unmodifiableCollection(propertyDefinitions);
        }

        public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
            return TestDiscoveryStrategy.class;
        }

        public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
            return new TestDiscoveryStrategy();
        }

        public Collection<PropertyDefinition> getConfigurationProperties() {
            return this.propertyDefinitions;
        }
    }

    private static class TestDiscoveryStrategy
    implements DiscoveryStrategy {
        private TestDiscoveryStrategy() {
        }

        public void start() {
        }

        public Collection<DiscoveryNode> discoverNodes() {
            try {
                ArrayList<DiscoveryNode> discoveryNodes = new ArrayList<DiscoveryNode>(4);
                Address privateAddress = new Address("127.0.0.1", 1);
                Address publicAddress = new Address("127.0.0.1", 50001);
                discoveryNodes.add((DiscoveryNode)new SimpleDiscoveryNode(privateAddress, publicAddress));
                privateAddress = new Address("127.0.0.1", 2);
                publicAddress = new Address("127.0.0.1", 50002);
                discoveryNodes.add((DiscoveryNode)new SimpleDiscoveryNode(privateAddress, publicAddress));
                privateAddress = new Address("127.0.0.1", 3);
                publicAddress = new Address("127.0.0.1", 50003);
                discoveryNodes.add((DiscoveryNode)new SimpleDiscoveryNode(privateAddress, publicAddress));
                privateAddress = new Address("127.0.0.1", 4);
                publicAddress = new Address("127.0.0.1", 50004);
                discoveryNodes.add((DiscoveryNode)new SimpleDiscoveryNode(privateAddress, publicAddress));
                return discoveryNodes;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void destroy() {
        }

        public PartitionGroupStrategy getPartitionGroupStrategy() {
            return null;
        }

        public Map<String, Object> discoverLocalMetadata() {
            return Collections.emptyMap();
        }
    }
}

