/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.discovery.multicast.MulticastDiscoveryStrategy;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.InputStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientToMemberDiscoveryTest
extends HazelcastTestSupport {
    public final TestHazelcastFactory factory = new TestHazelcastFactory();
    Config serverConfig;
    ClientConfig clientConfig;
    HazelcastInstance instance1;
    HazelcastInstance instance2;

    @Before
    public void setup() {
        String serverXmlFileName = "hazelcast-multicast-plugin.xml";
        String clientXmlFileName = "hazelcast-client-multicast-plugin.xml";
        InputStream xmlResource = MulticastDiscoveryStrategy.class.getClassLoader().getResourceAsStream(serverXmlFileName);
        this.serverConfig = new XmlConfigBuilder(xmlResource).build();
        InputStream xmlClientResource = MulticastDiscoveryStrategy.class.getClassLoader().getResourceAsStream(clientXmlFileName);
        this.clientConfig = new XmlClientConfigBuilder(xmlClientResource).build();
    }

    @After
    public void tearDown() {
        this.factory.terminateAll();
    }

    @Test
    public void clientTest() {
        this.instance1 = this.factory.newHazelcastInstance(this.serverConfig);
        this.instance2 = this.factory.newHazelcastInstance(this.serverConfig);
        HazelcastInstance client = this.factory.newHazelcastClient(this.clientConfig);
        ClientToMemberDiscoveryTest.assertClusterSizeEventually((int)2, (HazelcastInstance[])new HazelcastInstance[]{client});
    }
}

