/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.standalone.model;

import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;

public class MyPortableElement
implements Portable {
    public static final int FACTORY_ID = 1;
    public static final int CLASS_ID = 1;
    private int id;
    private Long date;

    private MyPortableElement() {
    }

    public MyPortableElement(int id) {
        this.id = id;
        this.date = 123L;
    }

    public int getFactoryId() {
        return 1;
    }

    public int getClassId() {
        return 1;
    }

    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("id", this.id);
        writer.writeLong("date", this.date.longValue());
    }

    public void readPortable(PortableReader reader) throws IOException {
        this.id = reader.readInt("id");
        this.date = reader.readLong("date");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MyPortableElement that = (MyPortableElement)o;
        if (this.id != that.id) {
            return false;
        }
        return this.date != null ? this.date.equals(that.date) : that.date == null;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        return result;
    }

    public static class Factory
    implements PortableFactory {
        public Portable create(int classId) {
            if (classId == 1) {
                return new MyPortableElement();
            }
            throw new IllegalArgumentException("Unknown class ID " + classId);
        }
    }
}

