/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.starter;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.starter.HazelcastAPIDelegatingClassloader;
import com.hazelcast.test.starter.HazelcastProxyFactory;
import com.hazelcast.test.starter.HazelcastStarter;
import com.hazelcast.test.starter.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HazelcastClientStarter {
    private HazelcastClientStarter() {
    }

    public static HazelcastInstance newHazelcastClient(String version, boolean enterprise) {
        return HazelcastClientStarter.newHazelcastClient(version, null, enterprise);
    }

    public static HazelcastInstance newHazelcastClient(String version, ClientConfig clientConfig, boolean enterprise) {
        ClassLoader classLoader = clientConfig == null ? null : clientConfig.getClassLoader();
        HazelcastAPIDelegatingClassloader classloader = HazelcastStarter.getTargetVersionClassloader((String)version, (boolean)enterprise, (ClassLoader)classLoader);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(null);
        try {
            Class hazelcastClass = classloader.loadClass("com.hazelcast.client.HazelcastClient");
            System.out.println(hazelcastClass + " loaded by " + hazelcastClass.getClassLoader());
            Class configClass = classloader.loadClass("com.hazelcast.client.config.ClientConfig");
            Object config = HazelcastStarter.getConfig((Object)clientConfig, (HazelcastAPIDelegatingClassloader)classloader, (Class)configClass);
            Method newHazelcastInstanceMethod = hazelcastClass.getMethod("newHazelcastClient", configClass);
            Object delegate = newHazelcastInstanceMethod.invoke(null, config);
            HazelcastInstance hazelcastInstance = (HazelcastInstance)HazelcastProxyFactory.proxyObjectForStarter((ClassLoader)HazelcastStarter.class.getClassLoader(), (Object)delegate);
            return hazelcastInstance;
        }
        catch (ClassNotFoundException e) {
            throw Utils.rethrow((Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw Utils.rethrow((Exception)e);
        }
        catch (IllegalAccessException e) {
            throw Utils.rethrow((Exception)e);
        }
        catch (InvocationTargetException e) {
            throw Utils.rethrow((Exception)e);
        }
        catch (InstantiationException e) {
            throw Utils.rethrow((Exception)e);
        }
        finally {
            if (contextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }
}

