/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.statistics;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.statistics.Statistics;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.cache.spi.CachingProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientStatisticsTest
extends ClientTestSupport {
    private static final int STATS_PERIOD_SECONDS = 1;
    private static final long STATS_PERIOD_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final String MAP_NAME = "StatTestMapFirst.First";
    private static final String CACHE_NAME = "StatTestICache,First";
    private static final String MAP_HITS_KEY = "nc.StatTestMapFirst.First.hits";
    private static final String CACHE_HITS_KEY = "nc.hz/StatTestICache,First.hits";
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testStatisticsCollectionNonDefaultPeriod() throws InterruptedException {
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        final HazelcastClientInstanceImpl client = this.createHazelcastClient();
        final ClientEngineImpl clientEngine = ClientStatisticsTest.getClientEngineImpl((HazelcastInstance)hazelcastInstance);
        long clientConnectionTime = System.currentTimeMillis();
        ClientStatisticsTest.waitForFirstStatisticsCollection(client, clientEngine);
        Map<String, String> stats = ClientStatisticsTest.getStats(client, clientEngine);
        String connStat = stats.get("clusterConnectionTimestamp");
        Assert.assertNotNull((String)String.format("clusterConnectionTimestamp should not be null (%s)", stats), (Object)connStat);
        Long connectionTimeStat = Long.valueOf(connStat);
        Assert.assertNotNull((String)String.format("connectionTimeStat should not be null (%s)", stats), (Object)connStat);
        ClientConnection ownerConnection = client.getConnectionManager().getOwnerConnection();
        String expectedClientAddress = String.format("%s:%d", ownerConnection.getLocalSocketAddress().getAddress().getHostAddress(), ownerConnection.getLocalSocketAddress().getPort());
        Assert.assertEquals((Object)expectedClientAddress, (Object)stats.get("clientAddress"));
        Assert.assertEquals((Object)BuildInfoProvider.getBuildInfo().getVersion(), (Object)stats.get("clientVersion"));
        Assert.assertTrue((String)String.format("connectionTimeStat was %d, clientConnectionTime was %d (%s)", connectionTimeStat, clientConnectionTime, stats), (clientConnectionTime >= connectionTimeStat ? 1 : 0) != 0);
        String queueSize = stats.get("executionService.userExecutorQueueSize");
        Assert.assertNotNull((String)String.format("executionService.userExecutorQueueSize should not be null (%s)", stats), (Object)queueSize);
        String mapHits = stats.get(MAP_HITS_KEY);
        Assert.assertNull((String)String.format("%s should be null (%s)", MAP_HITS_KEY, stats), (Object)mapHits);
        String cacheHits = stats.get(CACHE_HITS_KEY);
        Assert.assertNull((String)String.format("%s should be null (%s)", CACHE_HITS_KEY, stats), (Object)cacheHits);
        String lastStatisticsCollectionTimeString = stats.get("lastStatisticsCollectionTime");
        final long lastCollectionTime = Long.parseLong(lastStatisticsCollectionTimeString);
        client.getMap(MAP_NAME);
        ClientStatisticsTest.waitForNextStatsCollection(client, clientEngine, lastStatisticsCollectionTimeString);
        ClientStatisticsTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Map stats = ClientStatisticsTest.getStats(client, clientEngine);
                String mapHits = (String)stats.get(ClientStatisticsTest.MAP_HITS_KEY);
                Assert.assertNotNull((String)String.format("%s should not be null (%s)", ClientStatisticsTest.MAP_HITS_KEY, stats), (Object)mapHits);
                Assert.assertEquals((String)String.format("Expected 0 map hits (%s)", stats), (Object)"0", (Object)mapHits);
                String cacheHits = (String)stats.get(ClientStatisticsTest.CACHE_HITS_KEY);
                Assert.assertNull((String)String.format("%s should be null (%s)", ClientStatisticsTest.CACHE_HITS_KEY, stats), (Object)cacheHits);
                ClientStatisticsTest.verifyThatCollectionIsPeriodic(stats, lastCollectionTime);
            }
        });
        ClientStatisticsTest.produceSomeStats(hazelcastInstance, client);
        ClientStatisticsTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Map stats = ClientStatisticsTest.getStats(client, clientEngine);
                String mapHits = (String)stats.get(ClientStatisticsTest.MAP_HITS_KEY);
                Assert.assertNotNull((String)String.format("%s should not be null (%s)", ClientStatisticsTest.MAP_HITS_KEY, stats), (Object)mapHits);
                Assert.assertEquals((String)String.format("Expected 1 map hits (%s)", stats), (Object)"1", (Object)mapHits);
                String cacheHits = (String)stats.get(ClientStatisticsTest.CACHE_HITS_KEY);
                Assert.assertNotNull((String)String.format("%s should not be null (%s)", ClientStatisticsTest.CACHE_HITS_KEY, stats), (Object)cacheHits);
                Assert.assertEquals((String)String.format("Expected 1 cache hits (%s)", stats), (Object)"1", (Object)cacheHits);
            }
        });
    }

    @Test
    public void testStatisticsPeriod() {
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastClientInstanceImpl client = this.createHazelcastClient();
        ClientEngineImpl clientEngine = ClientStatisticsTest.getClientEngineImpl((HazelcastInstance)hazelcastInstance);
        ClientStatisticsTest.waitForFirstStatisticsCollection(client, clientEngine);
        Map<String, String> initialStats = ClientStatisticsTest.getStats(client, clientEngine);
        ClientStatisticsTest.produceSomeStats(hazelcastInstance, client);
        ClientStatisticsTest.waitForNextStatsCollection(client, clientEngine, initialStats.get("lastStatisticsCollectionTime"));
        Assert.assertNotEquals((String)"initial statistics should not be the same as current stats", initialStats, ClientStatisticsTest.getStats(client, clientEngine));
    }

    @Test
    public void testStatisticsClusterReconnect() {
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastClientInstanceImpl client = this.createHazelcastClient();
        hazelcastInstance.getLifecycleService().terminate();
        final CountDownLatch latch = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED.equals((Object)event.getState())) {
                    latch.countDown();
                }
            }
        });
        hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        ClientEngineImpl clientEngine = ClientStatisticsTest.getClientEngineImpl((HazelcastInstance)hazelcastInstance);
        ClientStatisticsTest.assertOpenEventually((CountDownLatch)latch);
        ClientStatisticsTest.waitForFirstStatisticsCollection(client, clientEngine);
        ClientStatisticsTest.getStats(client, clientEngine);
    }

    @Test
    public void testStatisticsTwoClients() {
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastClientInstanceImpl client1 = this.createHazelcastClient();
        HazelcastClientInstanceImpl client2 = this.createHazelcastClient();
        ClientEngineImpl clientEngine = ClientStatisticsTest.getClientEngineImpl((HazelcastInstance)hazelcastInstance);
        ClientStatisticsTest.sleepSeconds((int)2);
        Map clientStatistics = clientEngine.getClientStatistics();
        Assert.assertNotNull((Object)clientStatistics);
        Assert.assertEquals((long)2L, (long)clientStatistics.size());
        ArrayList<String> expectedUUIDs = new ArrayList<String>(2);
        expectedUUIDs.add(client1.getClientClusterService().getLocalClient().getUuid());
        expectedUUIDs.add(client2.getClientClusterService().getLocalClient().getUuid());
        for (Map.Entry clientEntry : clientStatistics.entrySet()) {
            Assert.assertTrue((boolean)expectedUUIDs.contains(clientEntry.getKey()));
            String stats = (String)clientEntry.getValue();
            Assert.assertNotNull((Object)stats);
            expectedUUIDs.remove(clientEntry.getKey());
        }
    }

    @Test
    public void testNoUpdateWhenDisabled() {
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        final ClientEngineImpl clientEngine = ClientStatisticsTest.getClientEngineImpl((HazelcastInstance)hazelcastInstance);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(Statistics.ENABLED.getName(), "false");
        clientConfig.setProperty(Statistics.PERIOD_SECONDS.getName(), Integer.toString(1));
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        ClientStatisticsTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Map statistics = clientEngine.getClientStatistics();
                Assert.assertEquals((long)0L, (long)statistics.size());
            }
        }, (long)3L);
    }

    @Test
    public void testEscapeSpecialCharacter() {
        String originalString = "stat1=value1.lastName,stat2=value2\\hello==";
        String escapedString = "stat1\\=value1\\.lastName\\,stat2\\=value2\\\\hello\\=\\=";
        StringBuilder buffer = new StringBuilder(originalString);
        Statistics.escapeSpecialCharacters((StringBuilder)buffer);
        Assert.assertEquals((Object)escapedString, (Object)buffer.toString());
        Assert.assertEquals((Object)originalString, (Object)Statistics.unescapeSpecialCharacters((String)escapedString));
    }

    @Test
    public void testSplit() {
        String escapedString = "stat1=value1.lastName,stat2=full\\name==hazel\\,ali,";
        Object[] expectedStrings = new String[]{"stat1=value1.lastName", "stat2=full\\name==hazel\\,ali"};
        List strings = Statistics.split((String)escapedString);
        Assert.assertArrayEquals((Object[])expectedStrings, (Object[])strings.toArray());
    }

    private HazelcastClientInstanceImpl createHazelcastClient() {
        ClientConfig clientConfig = new ClientConfig().setProperty(Statistics.ENABLED.getName(), "true").setProperty(Statistics.PERIOD_SECONDS.getName(), Integer.toString(1)).addNearCacheConfig(new NearCacheConfig(MAP_NAME)).addNearCacheConfig(new NearCacheConfig(CACHE_NAME));
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(20);
        HazelcastInstance clientInstance = this.hazelcastFactory.newHazelcastClient(clientConfig);
        return this.getHazelcastClientInstanceImpl(clientInstance);
    }

    private static void produceSomeStats(HazelcastInstance hazelcastInstance, HazelcastClientInstanceImpl client) {
        IMap map = client.getMap(MAP_NAME);
        map.put((Object)5, (Object)10);
        Assert.assertEquals((long)10L, (long)((Integer)map.get((Object)5)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)map.get((Object)5)).intValue());
        ICache<Integer, Integer> cache = ClientStatisticsTest.createCache(hazelcastInstance, CACHE_NAME, (HazelcastInstance)client);
        cache.put((Object)9, (Object)20);
        Assert.assertEquals((long)20L, (long)((Integer)cache.get((Object)9)).intValue());
        Assert.assertEquals((long)20L, (long)((Integer)cache.get((Object)9)).intValue());
    }

    /*
     * Exception decompiling
     */
    private static ICache<Integer, Integer> createCache(HazelcastInstance hazelcastInstance, String testCacheName, HazelcastInstance clientInstance) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CachingProvider getCachingProvider(HazelcastInstance instance) {
        return HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)instance);
    }

    private static <K, V> CacheConfig<K, V> createCacheConfig() {
        return new CacheConfig().setInMemoryFormat(InMemoryFormat.BINARY);
    }

    private static Map<String, String> getStats(HazelcastClientInstanceImpl client, ClientEngineImpl clientEngine) {
        Map clientStatistics = clientEngine.getClientStatistics();
        Assert.assertNotNull((String)"clientStatistics should not be null", (Object)clientStatistics);
        Assert.assertEquals((String)"clientStatistics.size() should be 1", (long)1L, (long)clientStatistics.size());
        Set entries = clientStatistics.entrySet();
        Map.Entry statEntry = entries.iterator().next();
        Assert.assertEquals((Object)client.getClientClusterService().getLocalClient().getUuid(), statEntry.getKey());
        return ClientStatisticsTest.parseStatValue((String)statEntry.getValue());
    }

    private static Map<String, String> parseStatValue(String value) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String stat : Statistics.split((String)value)) {
            List keyValue = Statistics.split((String)stat, (int)0, (char)'=');
            Assert.assertNotNull((String)String.format("keyValue should not be null (%s)", stat), (Object)keyValue);
            result.put(Statistics.unescapeSpecialCharacters((String)((String)keyValue.get(0))), Statistics.unescapeSpecialCharacters((String)((String)keyValue.get(1))));
        }
        return result;
    }

    private static void waitForFirstStatisticsCollection(final HazelcastClientInstanceImpl client, final ClientEngineImpl clientEngine) {
        ClientStatisticsTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                ClientStatisticsTest.getStats(client, clientEngine);
            }
        }, (long)3L);
    }

    private static void waitForNextStatsCollection(final HazelcastClientInstanceImpl client, final ClientEngineImpl clientEngine, final String lastStatisticsCollectionTime) {
        ClientStatisticsTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Map stats = ClientStatisticsTest.getStats(client, clientEngine);
                Assert.assertNotEquals((Object)lastStatisticsCollectionTime, stats.get("lastStatisticsCollectionTime"));
            }
        });
    }

    private static String verifyThatCollectionIsPeriodic(Map<String, String> stats, long lastCollectionTime) {
        String lastStatisticsCollectionTime = stats.get("lastStatisticsCollectionTime");
        long newCollectionTime = Long.parseLong(lastStatisticsCollectionTime);
        long timeDifferenceMillis = newCollectionTime - lastCollectionTime;
        double lowerThreshold = (double)STATS_PERIOD_MILLIS * 0.9;
        double upperThreshold = (double)STATS_PERIOD_MILLIS * 20.0;
        Assert.assertTrue((String)("Time difference between two collections is " + timeDifferenceMillis + " ms but, but it should be greater than " + lowerThreshold + " ms"), ((double)timeDifferenceMillis >= lowerThreshold ? 1 : 0) != 0);
        Assert.assertTrue((String)("Time difference between two collections is " + timeDifferenceMillis + " ms, but it should be less than " + upperThreshold + " ms"), ((double)timeDifferenceMillis <= upperThreshold ? 1 : 0) != 0);
        return lastStatisticsCollectionTime;
    }
}

