/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.stress;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.stress.StressTestSupport;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class})
public class MapUpdateStressTest
extends StressTestSupport {
    public static final int CLIENT_THREAD_COUNT = 5;
    public static final int MAP_SIZE = 100000;
    private HazelcastInstance client;
    private IMap<Integer, Integer> map;
    private StressThread[] stressThreads;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setRedoOperation(true);
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        this.map = this.client.getMap("map");
        this.stressThreads = new StressThread[5];
        for (int k = 0; k < this.stressThreads.length; ++k) {
            this.stressThreads[k] = new StressThread();
            this.stressThreads[k].start();
        }
    }

    @Override
    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.shutdown();
        }
        super.tearDown();
    }

    @Test
    @Ignore
    public void testChangingCluster() {
        this.test(true);
    }

    @Test(timeout=600000L)
    public void testFixedCluster() {
        this.test(false);
    }

    public void test(boolean clusterChangeEnabled) {
        this.setClusterChangeEnabled(clusterChangeEnabled);
        this.fillMap();
        this.startAndWaitForTestCompletion();
        this.joinAll(this.stressThreads);
        this.assertNoUpdateFailures();
    }

    private void assertNoUpdateFailures() {
        int[] increments = new int[100000];
        for (StressThread t : this.stressThreads) {
            t.addIncrements(increments);
        }
        HashSet<Integer> failedKeys = new HashSet<Integer>();
        for (int k = 0; k < 100000; ++k) {
            int expectedValue = increments[k];
            int foundValue = (Integer)this.map.get((Object)k);
            if (expectedValue == foundValue) continue;
            failedKeys.add(k);
        }
        if (failedKeys.isEmpty()) {
            return;
        }
        int index = 1;
        for (Integer key : failedKeys) {
            System.err.println("Failed write: " + index + " found:" + this.map.get((Object)key) + " expected:" + increments[key]);
            ++index;
        }
        Assert.fail((String)("There are failed writes, number of failures:" + failedKeys.size()));
    }

    private void fillMap() {
        System.out.println("==================================================================");
        System.out.println("Inserting data in map");
        System.out.println("==================================================================");
        for (int k = 0; k < 100000; ++k) {
            this.map.put((Object)k, (Object)0);
            if (k % 10000 != 0) continue;
            System.out.println("Inserted data: " + k);
        }
        System.out.println("==================================================================");
        System.out.println("Completed with inserting data in map");
        System.out.println("==================================================================");
    }

    public class StressThread
    extends StressTestSupport.TestThread {
        private final int[] increments = new int[100000];

        @Override
        public void doRun() throws Exception {
            while (!MapUpdateStressTest.this.isStopped()) {
                int oldValue;
                int key = this.random.nextInt(100000);
                int increment = this.random.nextInt(10);
                int n = key;
                this.increments[n] = this.increments[n] + increment;
                do {
                    oldValue = (Integer)MapUpdateStressTest.this.map.get((Object)key);
                } while (!MapUpdateStressTest.this.map.replace((Object)key, (Object)oldValue, (Object)(oldValue + increment)));
            }
        }

        public void addIncrements(int[] increments) {
            for (int k = 0; k < increments.length; ++k) {
                int n = k;
                increments[n] = increments[n] + this.increments[k];
            }
        }
    }
}

