/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.test;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class HazelcastFactoryTest
extends HazelcastTestSupport {
    private TestHazelcastFactory instanceFactory;

    @Before
    public void setUp() {
        this.instanceFactory = new TestHazelcastFactory();
    }

    @After
    public void tearDown() {
        this.instanceFactory.terminateAll();
    }

    @Test
    public void testTestHazelcastInstanceFactory_smartClients() {
        final HazelcastInstance instance1 = this.instanceFactory.newHazelcastInstance();
        final HazelcastInstance instance2 = this.instanceFactory.newHazelcastInstance();
        final HazelcastInstance instance3 = this.instanceFactory.newHazelcastInstance();
        final HazelcastInstance client1 = this.instanceFactory.newHazelcastClient();
        final HazelcastInstance client2 = this.instanceFactory.newHazelcastClient();
        HazelcastFactoryTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                HazelcastFactoryTest.touchRandomNode(client1);
                HazelcastFactoryTest.touchRandomNode(client2);
                HazelcastTestSupport.assertClusterSize((int)3, (HazelcastInstance[])new HazelcastInstance[]{instance1, instance2, instance3});
                Assert.assertEquals((long)2L, (long)instance1.getClientService().getConnectedClients().size());
                Assert.assertEquals((long)2L, (long)instance2.getClientService().getConnectedClients().size());
                Assert.assertEquals((long)2L, (long)instance3.getClientService().getConnectedClients().size());
            }
        });
    }

    @Test
    public void testTestHazelcastInstanceFactory_dummyClients() {
        final HazelcastInstance instance1 = this.instanceFactory.newHazelcastInstance();
        final HazelcastInstance instance2 = this.instanceFactory.newHazelcastInstance();
        final HazelcastInstance instance3 = this.instanceFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(false);
        final HazelcastInstance client1 = this.instanceFactory.newHazelcastClient(clientConfig);
        final HazelcastInstance client2 = this.instanceFactory.newHazelcastClient(clientConfig);
        HazelcastFactoryTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{instance1, instance2, instance3});
        HazelcastFactoryTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                HazelcastFactoryTest.touchRandomNode(client1);
                HazelcastFactoryTest.touchRandomNode(client2);
                int actual = instance1.getClientService().getConnectedClients().size() + instance2.getClientService().getConnectedClients().size() + instance3.getClientService().getConnectedClients().size();
                Assert.assertEquals((long)2L, (long)actual);
            }
        });
        HazelcastFactoryTest.assertClusterSizeEventually((int)3, (HazelcastInstance[])new HazelcastInstance[]{client1, client2});
    }

    private static void touchRandomNode(HazelcastInstance hazelcastInstance) {
        hazelcastInstance.getMap(HazelcastFactoryTest.randomString()).get((Object)HazelcastFactoryTest.randomString());
    }
}

