/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.topic;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTopicTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testListener() throws InterruptedException {
        ITopic topic = this.client.getTopic(HazelcastTestSupport.randomString());
        final CountDownLatch latch = new CountDownLatch(10);
        MessageListener listener = new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        };
        topic.addMessageListener(listener);
        for (int i = 0; i < 10; ++i) {
            topic.publish((Object)i);
        }
        Assert.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
    }

    @Test
    public void testRemoveListener() {
        ITopic topic = this.client.getTopic(HazelcastTestSupport.randomString());
        MessageListener listener = new MessageListener(){

            public void onMessage(Message message) {
            }
        };
        String id = topic.addMessageListener(listener);
        Assert.assertTrue((boolean)topic.removeMessageListener(id));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetLocalTopicStats() throws Exception {
        ITopic topic = this.client.getTopic(HazelcastTestSupport.randomString());
        topic.getLocalTopicStats();
    }
}

