/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.util.AbstractLoadBalancer;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipAdapter;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTxnTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private HazelcastInstance server;

    @Before
    public void setup() {
        this.server = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setRedoOperation(true);
        config.setLoadBalancer((LoadBalancer)new AbstractLoadBalancer(){

            public Member next() {
                Member[] members = this.getMembers();
                if (members == null || members.length == 0) {
                    return null;
                }
                return members[0];
            }
        });
        this.client = this.hazelcastFactory.newHazelcastClient(config);
        this.hazelcastFactory.newHazelcastInstance();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testTxnRollback() throws Exception {
        String queueName = ClientTxnTest.randomString();
        TransactionContext context = this.client.newTransactionContext();
        CountDownLatch txnRollbackLatch = new CountDownLatch(1);
        final CountDownLatch memberRemovedLatch = new CountDownLatch(1);
        this.client.getCluster().addMembershipListener((MembershipListener)new MembershipAdapter(){

            public void memberRemoved(MembershipEvent membershipEvent) {
                memberRemovedLatch.countDown();
            }
        });
        try {
            context.beginTransaction();
            Assert.assertNotNull((Object)context.getTxnId());
            TransactionalQueue queue = context.getQueue(queueName);
            queue.offer((Object)ClientTxnTest.randomString());
            this.server.shutdown();
            context.commitTransaction();
            Assert.fail((String)"commit should throw exception!!!");
        }
        catch (TransactionException e) {
            context.rollbackTransaction();
            txnRollbackLatch.countDown();
        }
        ClientTxnTest.assertOpenEventually((CountDownLatch)txnRollbackLatch);
        ClientTxnTest.assertOpenEventually((CountDownLatch)memberRemovedLatch);
        IQueue q = this.client.getQueue(queueName);
        Assert.assertNull((Object)q.poll());
        Assert.assertEquals((long)0L, (long)q.size());
    }

    @Test
    public void testTxnRollbackOnServerCrash() throws Exception {
        String queueName = ClientTxnTest.randomString();
        TransactionContext context = this.client.newTransactionContext();
        CountDownLatch txnRollbackLatch = new CountDownLatch(1);
        final CountDownLatch memberRemovedLatch = new CountDownLatch(1);
        context.beginTransaction();
        TransactionalQueue queue = context.getQueue(queueName);
        queue.offer((Object)ClientTxnTest.randomString());
        this.client.getCluster().addMembershipListener((MembershipListener)new MembershipAdapter(){

            public void memberRemoved(MembershipEvent membershipEvent) {
                memberRemovedLatch.countDown();
            }
        });
        this.server.getLifecycleService().terminate();
        try {
            context.commitTransaction();
            Assert.fail((String)"commit should throw exception !");
        }
        catch (TransactionException e) {
            context.rollbackTransaction();
            txnRollbackLatch.countDown();
        }
        ClientTxnTest.assertOpenEventually((CountDownLatch)txnRollbackLatch);
        ClientTxnTest.assertOpenEventually((CountDownLatch)memberRemovedLatch);
        IQueue q = this.client.getQueue(queueName);
        Assert.assertNull((Object)q.poll());
        Assert.assertEquals((long)0L, (long)q.size());
    }

    @Test
    public void testRollbackOnTimeout() {
        String name = ClientTxnTest.randomString();
        IQueue queue = this.client.getQueue(name);
        queue.offer((Object)ClientTxnTest.randomString());
        TransactionOptions options = new TransactionOptions().setTimeout(3L, TimeUnit.SECONDS);
        TransactionContext context = this.client.newTransactionContext(options);
        context.beginTransaction();
        try {
            try {
                context.getQueue(name).take();
            }
            catch (InterruptedException e) {
                Assert.fail();
            }
            ClientTxnTest.sleepAtLeastSeconds((long)5L);
            context.commitTransaction();
            Assert.fail();
        }
        catch (TransactionException e) {
            context.rollbackTransaction();
        }
        Assert.assertEquals((String)"Queue size should be 1", (long)1L, (long)queue.size());
    }
}

