/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.util.AbstractLoadBalancer;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTxnUniSocketTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testUniSocketClient_shouldNotOpenANewConnection() {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setRedoOperation(true);
        config.getNetworkConfig().setSmartRouting(false);
        config.setLoadBalancer((LoadBalancer)new AbstractLoadBalancer(){

            public Member next() {
                Member[] members = this.getMembers();
                if (members == null || members.length == 0) {
                    return null;
                }
                if (members.length == 2) {
                    return members[1];
                }
                return members[0];
            }
        });
        final HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        this.hazelcastFactory.newHazelcastInstance();
        ClientTxnUniSocketTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)2L, (long)client.getCluster().getMembers().size());
            }
        });
        ClientConnectionManager connectionManager = this.getHazelcastClientInstanceImpl(client).getConnectionManager();
        TransactionContext context = client.newTransactionContext();
        context.beginTransaction();
        context.commitTransaction();
        Assert.assertEquals((long)1L, (long)connectionManager.getActiveConnections().size());
    }
}

