/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.usercodedeployment;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.UserCodeDeploymentConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.FilteringClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import usercodedeployment.EntryProcessorWithAnonymousAndInner;
import usercodedeployment.IncrementingEntryProcessor;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class})
public class ClientUserCodeDeploymentTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();
    @Parameterized.Parameter(value=0)
    public UserCodeDeploymentConfig.ClassCacheMode classCacheMode;
    @Parameterized.Parameter(value=1)
    public UserCodeDeploymentConfig.ProviderMode providerMode;

    @After
    public void tearDown() throws Exception {
        this.factory.terminateAll();
    }

    @Parameterized.Parameters(name="ClassCacheMode:{0}, ProviderMode:{1}")
    public static Collection<Object[]> parameters() {
        LinkedList<Object[]> parameters = new LinkedList<Object[]>();
        for (UserCodeDeploymentConfig.ClassCacheMode classCacheMode : UserCodeDeploymentConfig.ClassCacheMode.values()) {
            for (UserCodeDeploymentConfig.ProviderMode providerMode : UserCodeDeploymentConfig.ProviderMode.values()) {
                parameters.add(new Object[]{classCacheMode, providerMode});
            }
        }
        return parameters;
    }

    private Config createNodeConfig() {
        Config config = new Config();
        FilteringClassLoader filteringCL = new FilteringClassLoader(Collections.singletonList("usercodedeployment"), null);
        config.setClassLoader((ClassLoader)filteringCL);
        config.getUserCodeDeploymentConfig().setEnabled(true).setClassCacheMode(this.classCacheMode).setProviderMode(this.providerMode);
        return config;
    }

    private ClientConfig createClientConfig() {
        ClientConfig config = new ClientConfig();
        ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        clientUserCodeDeploymentConfig.addClass("usercodedeployment.IncrementingEntryProcessor");
        config.setUserCodeDeploymentConfig(clientUserCodeDeploymentConfig.setEnabled(true));
        return config;
    }

    @Test
    public void testSingleMember() {
        ClientConfig clientConfig = this.createClientConfig();
        Config config = this.createNodeConfig();
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.assertCodeDeploymentWorking(client, (EntryProcessor)new IncrementingEntryProcessor());
    }

    @Test
    public void testWithMultipleMembers() {
        ClientConfig clientConfig = this.createClientConfig();
        Config config = this.createNodeConfig();
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.factory.newHazelcastInstance(config);
        this.assertCodeDeploymentWorking(client, (EntryProcessor)new IncrementingEntryProcessor());
    }

    @Test
    public void testWithMultipleMembersAtStart() {
        ClientConfig clientConfig = this.createClientConfig();
        Config config = this.createNodeConfig();
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.assertCodeDeploymentWorking(client, (EntryProcessor)new IncrementingEntryProcessor());
    }

    @Test
    public void testWithMultipleNodes_clientReconnectsToNewNode() {
        ClientConfig clientConfig = this.createClientConfig();
        Config config = this.createNodeConfig();
        HazelcastInstance firstInstance = this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.factory.newHazelcastInstance(config);
        firstInstance.getLifecycleService().shutdown();
        this.assertCodeDeploymentWorking(client, (EntryProcessor)new IncrementingEntryProcessor());
    }

    private void assertCodeDeploymentWorking(HazelcastInstance client, EntryProcessor entryProcessor) {
        int i;
        int keyCount = 100;
        IMap map = client.getMap(ClientUserCodeDeploymentTest.randomName());
        for (i = 0; i < keyCount; ++i) {
            map.put((Object)i, (Object)0);
        }
        map.executeOnEntries(entryProcessor);
        for (i = 0; i < keyCount; ++i) {
            Assert.assertEquals((long)1L, (long)((Integer)map.get((Object)i)).intValue());
        }
    }

    @Test
    public void testWithMultipleMembers_anonymousAndInnerClasses() {
        ClientConfig clientConfig = new ClientConfig();
        ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        clientUserCodeDeploymentConfig.addJar("EntryProcessorWithAnonymousAndInner.jar");
        clientConfig.setUserCodeDeploymentConfig(clientUserCodeDeploymentConfig.setEnabled(true));
        Config config = this.createNodeConfig();
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        this.factory.newHazelcastInstance(config);
        this.assertCodeDeploymentWorking(client, (EntryProcessor)new EntryProcessorWithAnonymousAndInner());
    }
}

