/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientFactory;
import com.hazelcast.client.HazelcastClientManager;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.impl.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.client.util.ClientStateListener;
import com.hazelcast.config.Config;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientRegressionWithRealNetworkTest
extends ClientTestSupport {
    @After
    public void cleanUp() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testClientPortConnection() {
        Config config1 = new Config();
        config1.getGroupConfig().setName("foo");
        config1.getNetworkConfig().setPort(5701);
        HazelcastInstance instance1 = Hazelcast.newHazelcastInstance((Config)config1);
        instance1.getMap("map").put((Object)"key", (Object)"value");
        Config config2 = new Config();
        config2.getGroupConfig().setName("bar");
        config2.getNetworkConfig().setPort(5702);
        Hazelcast.newHazelcastInstance((Config)config2);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setName("bar");
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        IMap map = client.getMap("map");
        Assert.assertNull((Object)map.put((Object)"key", (Object)"value"));
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testClientConnectionBeforeServerReady() throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                Hazelcast.newHazelcastInstance();
            }
        });
        final CountDownLatch clientLatch = new CountDownLatch(1);
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                ClientConfig config = new ClientConfig();
                config.getNetworkConfig().setConnectionAttemptLimit(10);
                HazelcastClient.newHazelcastClient((ClientConfig)config);
                clientLatch.countDown();
            }
        });
        ClientRegressionWithRealNetworkTest.assertOpenEventually((CountDownLatch)clientLatch);
    }

    @Test
    public void testConnectWithDNSHostnames() throws InterruptedException {
        Config config = new Config();
        config.getNetworkConfig().setPublicAddress("localhost");
        HazelcastInstance hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{"localhost"}).setConnectionAttemptLimit(Integer.MAX_VALUE);
        ClientStateListener clientStateListener = new ClientStateListener(clientConfig);
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(client);
        final ClientConnectionManager connectionManager = clientInstanceImpl.getConnectionManager();
        Hazelcast.newHazelcastInstance((Config)config);
        ClientRegressionWithRealNetworkTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)2L, (long)connectionManager.getActiveConnections().size());
            }
        });
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                LifecycleEvent.LifecycleState state = event.getState();
                if (state.equals((Object)LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED)) {
                    disconnectedLatch.countDown();
                } else if (state.equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED)) {
                    connectedLatch.countDown();
                }
            }
        });
        hazelcastInstance.shutdown();
        ClientRegressionWithRealNetworkTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        ClientRegressionWithRealNetworkTest.assertOpenEventually((CountDownLatch)connectedLatch);
        Assert.assertEquals((long)1L, (long)connectionManager.getActiveConnections().size());
    }

    @Test
    public void testListenersWhenDNSHostnamesAreUsed() {
        Config config = new Config();
        int heartBeatSeconds = 5;
        config.getNetworkConfig().setPublicAddress("localhost");
        config.setProperty(GroupProperty.CLIENT_HEARTBEAT_TIMEOUT_SECONDS.getName(), Integer.toString(heartBeatSeconds));
        HazelcastInstance hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
        ClientConfig clientConfig = new ClientConfig();
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        networkConfig.addAddress(new String[]{"localhost"});
        networkConfig.setConnectionAttemptLimit(Integer.MAX_VALUE);
        final HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        final IMap map = client.getMap("test");
        final AtomicInteger eventCount = new AtomicInteger(0);
        map.addEntryListener((MapListener)new EntryAddedListener(){

            public void entryAdded(EntryEvent event) {
                eventCount.incrementAndGet();
            }
        }, false);
        Hazelcast.newHazelcastInstance((Config)config);
        ClientRegressionWithRealNetworkTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                HazelcastClientInstanceImpl clientInstanceImpl = ClientRegressionWithRealNetworkTest.this.getHazelcastClientInstanceImpl(client);
                int size = clientInstanceImpl.getConnectionManager().getActiveConnections().size();
                Assert.assertEquals((long)2L, (long)size);
            }
        });
        hazelcastInstance.shutdown();
        ClientRegressionWithRealNetworkTest.sleepAtLeastSeconds((long)(2 * heartBeatSeconds));
        ClientRegressionWithRealNetworkTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                map.put((Object)1, (Object)2);
                Assert.assertNotEquals((long)0L, (long)eventCount.get());
            }
        });
    }

    @Test
    public void testOperationsContinueWhenOwnerDisconnected_reconnectModeAsync() throws Exception {
        this.testOperationsContinueWhenOwnerDisconnected(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
    }

    @Test
    public void testOperationsContinueWhenOwnerDisconnected_reconnectModeOn() throws Exception {
        this.testOperationsContinueWhenOwnerDisconnected(ClientConnectionStrategyConfig.ReconnectMode.ON);
    }

    private void testOperationsContinueWhenOwnerDisconnected(ClientConnectionStrategyConfig.ReconnectMode reconnectMode) throws Exception {
        HazelcastInstance instance1 = Hazelcast.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getConnectionStrategyConfig().setReconnectMode(reconnectMode);
        clientConfig.setProperty(ClientProperty.ALLOW_INVOCATIONS_WHEN_DISCONNECTED.getName(), "true");
        final AtomicBoolean waitFlag = new AtomicBoolean();
        final CountDownLatch testFinished = new CountDownLatch(1);
        final AddressProvider addressProvider = new AddressProvider(){

            public Collection<Address> loadAddresses() {
                if (waitFlag.get()) {
                    try {
                        testFinished.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return AddressHelper.getSocketAddresses((String)"127.0.0.1");
            }
        };
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "3");
        HazelcastInstance client = HazelcastClientManager.newHazelcastClient((ClientConfig)clientConfig, (HazelcastClientFactory)new HazelcastClientFactory(){

            public HazelcastClientInstanceImpl createHazelcastInstanceClient(ClientConfig config, ClientConnectionManagerFactory factory) {
                return new HazelcastClientInstanceImpl(config, factory, addressProvider);
            }

            public HazelcastClientProxy createProxy(HazelcastClientInstanceImpl client) {
                return new HazelcastClientProxy(client);
            }
        });
        HazelcastInstance instance2 = Hazelcast.newHazelcastInstance();
        ClientRegressionWithRealNetworkTest.warmUpPartitions((HazelcastInstance[])new HazelcastInstance[]{instance1, instance2});
        String keyOwnedBy2 = ClientRegressionWithRealNetworkTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        IMap clientMap = client.getMap("test");
        waitFlag.set(true);
        instance1.shutdown();
        clientMap.put((Object)keyOwnedBy2, (Object)1);
        Assert.assertEquals((Object)1, (Object)clientMap.get((Object)keyOwnedBy2));
        testFinished.countDown();
    }
}

