/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.cache.CacheClearTest;
import com.hazelcast.cache.ICache;
import com.hazelcast.client.HazelcastClientManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.spi.CachingProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheClearTest
extends CacheClearTest {
    private TestHazelcastFactory clientFactory;
    private HazelcastInstance client;

    protected TestHazelcastInstanceFactory getInstanceFactory(int instanceCount) {
        this.clientFactory = new TestHazelcastFactory();
        return this.clientFactory;
    }

    protected ClientConfig createClientConfig() {
        NearCacheConfig nearCacheConfig = new NearCacheConfig("myCache").setInMemoryFormat(InMemoryFormat.OBJECT).setCacheLocalEntries(false).setEvictionConfig(new EvictionConfig(10000, EvictionConfig.MaxSizePolicy.ENTRY_COUNT, EvictionPolicy.LFU)).setInvalidateOnChange(true).setLocalUpdatePolicy(NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE).setMaxIdleSeconds(600).setTimeToLiveSeconds(60);
        return new ClientConfig().addNearCacheConfig(nearCacheConfig);
    }

    protected void onSetup() {
        super.onSetup();
        ClientConfig clientConfig = this.createClientConfig();
        this.client = this.clientFactory.newHazelcastClient(clientConfig);
    }

    @Test
    public void testClientInvalidationListenerCallCount() {
        ICache cache = this.createCache();
        Map entries = this.createAndFillEntries();
        for (Map.Entry entry : entries.entrySet()) {
            cache.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : entries.entrySet()) {
            String key = (String)entry.getKey();
            String expectedValue = (String)entries.get(key);
            String actualValue = (String)cache.get((Object)key);
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        }
        final AtomicInteger counter = new AtomicInteger(0);
        CacheConfig config = (CacheConfig)cache.getConfiguration(CacheConfig.class);
        this.registerInvalidationListener(new EventHandler(){

            public void handle(Object event) {
                counter.getAndIncrement();
            }

            public void beforeListenerRegister() {
            }

            public void onListenerRegister() {
            }
        }, config.getNameWithPrefix());
        cache.clear();
        ClientCacheClearTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)counter.get());
            }
        }, (long)2L);
        ClientCacheClearTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((counter.get() <= 1 ? 1 : 0) != 0);
            }
        }, (long)3L);
    }

    @Test
    public void testClientInvalidationListenerCallCountWhenServerCacheClearUsed() {
        ICache cache = this.createCache();
        Map entries = this.createAndFillEntries();
        for (Map.Entry entry : entries.entrySet()) {
            cache.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : entries.entrySet()) {
            String key = (String)entry.getKey();
            String expectedValue = (String)entries.get(key);
            String actualValue = (String)cache.get((Object)key);
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        }
        final AtomicInteger counter = new AtomicInteger(0);
        CacheConfig config = (CacheConfig)cache.getConfiguration(CacheConfig.class);
        this.registerInvalidationListener(new EventHandler(){

            public void handle(Object event) {
                counter.getAndIncrement();
            }

            public void beforeListenerRegister() {
            }

            public void onListenerRegister() {
            }
        }, config.getNameWithPrefix());
        ICache serverCache = this.getHazelcastInstance().getCacheManager().getCache(config.getName());
        serverCache.clear();
        ClientCacheClearTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)counter.get());
            }
        }, (long)2L);
        ClientCacheClearTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((counter.get() <= 1 ? 1 : 0) != 0);
            }
        }, (long)3L);
    }

    protected void onTearDown() {
        super.onTearDown();
        this.client = null;
        HazelcastClientManager.shutdownAll();
    }

    protected CachingProvider getCachingProvider() {
        return HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)this.client);
    }

    private void registerInvalidationListener(EventHandler handler, String nameWithPrefix) {
        ListenerMessageCodec listenerCodec = this.createInvalidationListenerCodec(nameWithPrefix);
        HazelcastClientProxy hzClient = (HazelcastClientProxy)this.client;
        HazelcastClientInstanceImpl clientInstance = hzClient.client;
        clientInstance.getListenerService().registerListener(listenerCodec, handler);
    }

    private ListenerMessageCodec createInvalidationListenerCodec(final String nameWithPrefix) {
        return new ListenerMessageCodec(){

            public ClientMessage encodeAddRequest(boolean localOnly) {
                return CacheAddInvalidationListenerCodec.encodeRequest((String)nameWithPrefix, (boolean)localOnly);
            }

            public String decodeAddResponse(ClientMessage clientMessage) {
                return CacheAddInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return CacheRemoveEntryListenerCodec.encodeRequest((String)nameWithPrefix, (String)realRegistrationId);
            }

            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }
}

