/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastTestSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import org.junit.After;
import org.junit.Before;

public abstract class ClientNearCacheTestSupport
extends HazelcastTestSupport {
    protected static final String DEFAULT_CACHE_NAME = "ClientCache";
    protected final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    protected HazelcastInstance serverInstance;

    @Before
    public final void factoryInitialization() {
        this.serverInstance = this.hazelcastFactory.newHazelcastInstance(this.createConfig());
    }

    @After
    public final void factoryShutdown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected Config createConfig() {
        return new Config();
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig();
    }

    protected CacheConfig createCacheConfig(InMemoryFormat inMemoryFormat) {
        CacheConfig cacheConfig = new CacheConfig().setName(DEFAULT_CACHE_NAME).setInMemoryFormat(inMemoryFormat);
        cacheConfig.setCacheLoaderFactory(FactoryBuilder.factoryOf(TestCacheLoader.class));
        return cacheConfig;
    }

    protected NearCacheConfig createNearCacheConfig(InMemoryFormat inMemoryFormat) {
        return new NearCacheConfig().setName(DEFAULT_CACHE_NAME).setInMemoryFormat(inMemoryFormat);
    }

    protected static String generateValueFromKey(Integer key) {
        return "Value-" + key;
    }

    public static class TestCacheLoader
    implements CacheLoader<Integer, String> {
        public String load(Integer key) throws CacheLoaderException {
            return String.valueOf(2 * key);
        }

        public Map<Integer, String> loadAll(Iterable<? extends Integer> keys) throws CacheLoaderException {
            HashMap<Integer, String> entries = new HashMap<Integer, String>();
            Iterator<? extends Integer> iterator = keys.iterator();
            while (iterator.hasNext()) {
                int key = iterator.next();
                entries.put(key, String.valueOf(2 * key));
            }
            return entries;
        }
    }
}

