/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheEventHandler;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.impl.NearCachedClientCacheProxy;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class CacheMetaDataGeneratorTest
extends HazelcastTestSupport {
    private static final String CACHE_NAME = "test";
    private static final String PREFIXED_CACHE_NAME = "/hz/test";
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private final ClientConfig clientConfig = this.newClientConfig();
    private final CacheConfig cacheConfig = this.newCacheConfig();
    private Cache clientCache;
    private Cache serverCache;
    private HazelcastInstance server;

    @Before
    public void setUp() throws Exception {
        NearCacheConfig nearCacheConfig = this.newNearCacheConfig();
        nearCacheConfig.setInvalidateOnChange(true);
        this.clientConfig.addNearCacheConfig(nearCacheConfig);
        this.cacheConfig.getEvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(Integer.MAX_VALUE);
        this.cacheConfig.setName(CACHE_NAME);
        Config config = this.getConfig();
        this.server = this.factory.newHazelcastInstance(config);
        HazelcastServerCachingProvider provider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)this.server);
        CacheManager serverCacheManager = provider.getCacheManager();
        this.serverCache = serverCacheManager.createCache(CACHE_NAME, (Configuration)this.cacheConfig);
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void destroying_cache_removes_related_metadata_when_near_cache_exists() throws Exception {
        this.clientCache = this.createCacheFromNewClient();
        this.serverCache.put((Object)1, (Object)1);
        Assert.assertNotNull(CacheMetaDataGeneratorTest.getMetaDataGenerator(this.server).getSequenceGenerators().get(PREFIXED_CACHE_NAME));
        ((ICache)this.clientCache).destroy();
        Assert.assertNull(CacheMetaDataGeneratorTest.getMetaDataGenerator(this.server).getSequenceGenerators().get(PREFIXED_CACHE_NAME));
    }

    @Test
    public void destroying_cache_removes_related_metadata_when_near_cache_not_exists() throws Exception {
        this.serverCache.put((Object)1, (Object)1);
        Assert.assertNull(CacheMetaDataGeneratorTest.getMetaDataGenerator(this.server).getSequenceGenerators().get(PREFIXED_CACHE_NAME));
        ((ICache)this.serverCache).destroy();
        Assert.assertNull(CacheMetaDataGeneratorTest.getMetaDataGenerator(this.server).getSequenceGenerators().get(PREFIXED_CACHE_NAME));
    }

    private Cache createCacheFromNewClient() {
        HazelcastClientProxy client = (HazelcastClientProxy)this.factory.newHazelcastClient(this.clientConfig);
        HazelcastClientCachingProvider clientCachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = clientCachingProvider.getCacheManager();
        Cache cache = cacheManager.createCache(CACHE_NAME, (Configuration)this.cacheConfig);
        assert (cache instanceof NearCachedClientCacheProxy);
        return cache;
    }

    protected ClientConfig newClientConfig() {
        return new ClientConfig();
    }

    protected CacheConfig newCacheConfig() {
        return new CacheConfig();
    }

    protected NearCacheConfig newNearCacheConfig() {
        return new NearCacheConfig(CACHE_NAME);
    }

    private static MetaDataGenerator getMetaDataGenerator(HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = CacheMetaDataGeneratorTest.getNodeEngineImpl((HazelcastInstance)member);
        CacheService service = (CacheService)nodeEngineImpl.getService("hz:impl:cacheService");
        CacheEventHandler cacheEventHandler = service.getCacheEventHandler();
        return cacheEventHandler.getMetaDataGenerator();
    }
}

