/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.nearcache;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.nearcache.ClientCacheInvalidationListener;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.DataStructureAdapterMethod;
import com.hazelcast.internal.adapter.ICacheCacheLoader;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCacheBasicTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import javax.cache.CacheManager;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheNearCacheBasicTest
extends AbstractNearCacheBasicTest<Data, String> {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Before
    public void setUp() {
        this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)NearCacheConfig.DEFAULT_MEMORY_FORMAT, (boolean)false).setLocalUpdatePolicy(NearCacheConfig.DEFAULT_LOCAL_UPDATE_POLICY);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    protected void assumeThatMethodIsAvailable(DataStructureAdapterMethod method) {
        NearCacheTestUtils.assumeThatMethodIsAvailable(ICacheDataStructureAdapter.class, (DataStructureAdapterMethod)method);
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(int size, boolean loaderEnabled) {
        Config config = this.createConfig();
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.nearCacheConfig, loaderEnabled);
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastServerCachingProvider memberProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)member);
        HazelcastServerCacheManager memberCacheManager = (HazelcastServerCacheManager)memberProvider.getCacheManager();
        ICache memberCache = memberCacheManager.createCache("defaultNearCache", cacheConfig);
        ICacheDataStructureAdapter dataAdapter = new ICacheDataStructureAdapter(memberCache);
        ClientCacheNearCacheBasicTest.populateDataAdapter((DataStructureAdapter)dataAdapter, (int)size);
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder(cacheConfig);
        return builder.setDataInstance(member).setDataAdapter((DataStructureAdapter)dataAdapter).setMemberCacheManager(memberCacheManager).build();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createNearCacheContext() {
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.nearCacheConfig, false);
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder(cacheConfig);
        return builder.build();
    }

    protected Config createConfig() {
        return this.getConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "5").setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getName(), "1");
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig().addNearCacheConfig(this.nearCacheConfig);
    }

    private <K, V> CacheConfig<K, V> createCacheConfig(NearCacheConfig nearCacheConfig, boolean loaderEnabled) {
        CacheConfig cacheConfig = new CacheConfig().setName("defaultNearCache").setInMemoryFormat(nearCacheConfig.getInMemoryFormat());
        if (nearCacheConfig.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            cacheConfig.getEvictionConfig().setEvictionPolicy(EvictionPolicy.LRU).setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE).setSize(90);
        }
        if (loaderEnabled) {
            cacheConfig.setReadThrough(true).setCacheLoaderFactory((Factory)new FactoryBuilder.ClassFactory(ICacheCacheLoader.class));
        }
        return cacheConfig;
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder(CacheConfig<K, V> cacheConfig) {
        ClientConfig clientConfig = this.createClientConfig();
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        ICache clientCache = cacheManager.createCache("defaultNearCache", cacheConfig);
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        String cacheNameWithPrefix = cacheManager.getCacheNameWithPrefix("defaultNearCache");
        NearCache nearCache = nearCacheManager.getNearCache(cacheNameWithPrefix);
        return new NearCacheTestContextBuilder(this.nearCacheConfig, client.getSerializationService()).setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new ICacheDataStructureAdapter(clientCache)).setNearCache(nearCache).setNearCacheManager(nearCacheManager).setCacheManager((CacheManager)cacheManager).setInvalidationListener(ClientCacheInvalidationListener.createInvalidationEventHandler(clientCache));
    }
}

