/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.nearcache;

import com.hazelcast.cache.CacheUtil;
import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.cache.nearcache.ClientCacheInvalidationListener;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCachePreloaderTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheNearCachePreloaderTest
extends AbstractNearCachePreloaderTest<Data, String> {
    protected final String cacheFileName;
    protected final File storeFile;
    protected final File storeLockFile;
    private final TestHazelcastFactory hazelcastFactory;

    public ClientCacheNearCachePreloaderTest() {
        this.cacheFileName = IOUtil.toFileName((String)CacheUtil.getDistributedObjectName((String)this.defaultNearCache));
        this.storeFile = new File("nearCache-" + this.cacheFileName + ".store").getAbsoluteFile();
        this.storeLockFile = new File(this.storeFile.getName() + ".lock").getAbsoluteFile();
        this.hazelcastFactory = new TestHazelcastFactory();
    }

    @Before
    public void setUp() {
        this.nearCacheConfig = this.getNearCacheConfig(NearCacheConfig.DEFAULT_MEMORY_FORMAT, false, true, 10023, this.storeFile.getParent());
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected File getStoreFile() {
        return this.storeFile;
    }

    protected File getStoreLockFile() {
        return this.storeLockFile;
    }

    protected <K, V> DataStructureAdapter<K, V> getDataStructure(NearCacheTestContext<K, V, Data, String> context, String name) {
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.nearCacheConfig);
        Cache memberCache = context.cacheManager.createCache(name, (Configuration)cacheConfig.setName(name));
        return new ICacheDataStructureAdapter((ICache)memberCache.unwrap(ICache.class));
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(boolean createNearCacheInstance, int keyCount, AbstractNearCachePreloaderTest.KeyType keyType) {
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.nearCacheConfig);
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(this.getConfig());
        HazelcastServerCachingProvider memberProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)member);
        HazelcastServerCacheManager memberCacheManager = (HazelcastServerCacheManager)memberProvider.getCacheManager();
        ICache memberCache = memberCacheManager.createCache(this.nearCacheConfig.getName(), cacheConfig);
        ICacheDataStructureAdapter dataAdapter = new ICacheDataStructureAdapter(memberCache);
        ClientCacheNearCachePreloaderTest.populateDataAdapter((DataStructureAdapter)dataAdapter, (int)keyCount, (AbstractNearCachePreloaderTest.KeyType)keyType);
        if (createNearCacheInstance) {
            return this.createNearCacheContextBuilder(cacheConfig).setDataInstance(member).setDataAdapter((DataStructureAdapter)dataAdapter).setMemberCacheManager(memberCacheManager).build();
        }
        return new NearCacheTestContextBuilder(this.nearCacheConfig, (SerializationService)ClientCacheNearCachePreloaderTest.getSerializationService((HazelcastInstance)member)).setDataInstance(member).setDataAdapter((DataStructureAdapter)dataAdapter).build();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createNearCacheContext() {
        CacheConfig<K, V> cacheConfig = this.createCacheConfig(this.nearCacheConfig);
        return this.createNearCacheContextBuilder(cacheConfig).build();
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private <K, V> CacheConfig<K, V> createCacheConfig(NearCacheConfig nearCacheConfig) {
        CacheConfig cacheConfig = new CacheConfig().setName(nearCacheConfig.getName()).setInMemoryFormat(nearCacheConfig.getInMemoryFormat());
        if (nearCacheConfig.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            cacheConfig.getEvictionConfig().setEvictionPolicy(EvictionPolicy.LRU).setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE).setSize(90);
        }
        return cacheConfig;
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder(CacheConfig<K, V> cacheConfig) {
        ClientConfig clientConfig = this.getClientConfig().addNearCacheConfig(this.nearCacheConfig);
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        HazelcastClientCacheManager cacheManager = (HazelcastClientCacheManager)provider.getCacheManager();
        String cacheNameWithPrefix = cacheManager.getCacheNameWithPrefix(this.nearCacheConfig.getName());
        ICache clientCache = cacheManager.createCache(this.nearCacheConfig.getName(), cacheConfig);
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache(cacheNameWithPrefix);
        return new NearCacheTestContextBuilder(this.nearCacheConfig, client.getSerializationService()).setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new ICacheDataStructureAdapter(clientCache)).setNearCache(nearCache).setNearCacheManager(nearCacheManager).setCacheManager((CacheManager)cacheManager).setInvalidationListener(ClientCacheInvalidationListener.createInvalidationEventHandler(clientCache));
    }
}

