/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cluster;

import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientClusterServiceMemberListTest
extends HazelcastTestSupport {
    private Config liteConfig = new Config().setLiteMember(true);
    private TestHazelcastFactory factory;
    private HazelcastInstance liteInstance;
    private HazelcastInstance dataInstance;
    private HazelcastInstance dataInstance2;
    private HazelcastInstance client;

    @Before
    public void before() {
        this.factory = new TestHazelcastFactory();
        this.liteInstance = this.factory.newHazelcastInstance(this.liteConfig);
        this.dataInstance = this.factory.newHazelcastInstance();
        this.dataInstance2 = this.factory.newHazelcastInstance();
        this.client = this.factory.newHazelcastClient();
    }

    @After
    public void after() {
        this.factory.terminateAll();
    }

    @Test
    public void testLiteMembers() {
        ClientClusterServiceMemberListTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                ClientClusterService clusterService = ClientClusterServiceMemberListTest.this.getClientClusterService(ClientClusterServiceMemberListTest.this.client);
                Collection members = clusterService.getMembers(MemberSelectors.LITE_MEMBER_SELECTOR);
                ClientClusterServiceMemberListTest.this.verifyMembers(members, Collections.singletonList(ClientClusterServiceMemberListTest.this.liteInstance));
                junit.framework.Assert.assertEquals((int)1, (int)clusterService.getSize(MemberSelectors.LITE_MEMBER_SELECTOR));
            }
        });
    }

    @Test
    public void testDataMembers() {
        ClientClusterServiceMemberListTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                ClientClusterService clusterService = ClientClusterServiceMemberListTest.this.getClientClusterService(ClientClusterServiceMemberListTest.this.client);
                Collection members = clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
                ClientClusterServiceMemberListTest.this.verifyMembers(members, Arrays.asList(ClientClusterServiceMemberListTest.this.dataInstance, ClientClusterServiceMemberListTest.this.dataInstance2));
                junit.framework.Assert.assertEquals((int)2, (int)clusterService.getSize(MemberSelectors.DATA_MEMBER_SELECTOR));
            }
        });
    }

    @Test
    public void testMemberListOrderConsistentWithServer() {
        Set membersFromClient = this.client.getCluster().getMembers();
        Set membersFromServer = this.dataInstance.getCluster().getMembers();
        Assert.assertArrayEquals((Object[])membersFromClient.toArray(), (Object[])membersFromServer.toArray());
    }

    private void verifyMembers(Collection<Member> membersToCheck, Collection<HazelcastInstance> membersToExpect) {
        for (HazelcastInstance instance : membersToExpect) {
            ClientClusterServiceMemberListTest.assertContains(membersToCheck, (Object)this.getLocalMember(instance));
        }
        junit.framework.Assert.assertEquals((int)membersToExpect.size(), (int)membersToCheck.size());
    }

    private Member getLocalMember(HazelcastInstance instance) {
        return ClientClusterServiceMemberListTest.getNode((HazelcastInstance)instance).getLocalMember();
    }

    private ClientClusterService getClientClusterService(HazelcastInstance client) {
        return ClientTestUtil.getHazelcastClientInstanceImpl(client).getClientClusterService();
    }
}

