/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cluster;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.instance.DefaultNodeExtension;
import com.hazelcast.instance.HazelcastInstanceFactory;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeContext;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.test.mocknetwork.MockNodeContext;
import com.hazelcast.test.mocknetwork.TestNodeRegistry;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientNodeExtensionTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory;

    @Before
    public void before() throws IOException {
        this.factory = new TestHazelcastFactory();
    }

    @After
    public void after() {
        this.factory.terminateAll();
    }

    @Test(expected=IllegalStateException.class)
    public void test_canNotConnect_whenNodeExtensionIsNotComplete() throws UnknownHostException {
        HazelcastInstanceFactory.newHazelcastInstance((Config)new Config(), (String)ClientNodeExtensionTest.randomName(), (NodeContext)new ManagedExtensionNodeContext(this.factory.getRegistry(), new Address("127.0.0.1", 5555), false));
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{"127.0.0.1:5555"});
        this.factory.newHazelcastClient(clientConfig);
    }

    @Test(expected=OperationTimeoutException.class)
    public void test_canGetFromMap_whenNodeExtensionIsNotComplete() {
        IMap map = null;
        ManagedExtensionNodeContext nodeContext = null;
        try {
            nodeContext = new ManagedExtensionNodeContext(this.factory.getRegistry(), new Address("127.0.0.1", 5555), true);
            HazelcastInstanceFactory.newHazelcastInstance((Config)new Config(), (String)ClientNodeExtensionTest.randomName(), (NodeContext)nodeContext);
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "3");
            clientConfig.getNetworkConfig().addAddress(new String[]{"127.0.0.1:5555"});
            HazelcastInstance hazelcastClient = this.factory.newHazelcastClient(clientConfig);
            map = hazelcastClient.getMap(ClientNodeExtensionTest.randomMapName());
            Assert.assertNull((Object)map.get((Object)"dummy"));
        }
        catch (Throwable t) {
            Assert.fail((String)("Should not throw exception! Error:" + t));
        }
        nodeContext.setStartupDone(false);
        map.get((Object)"dummy");
    }

    private class ManagedExtensionNodeContext
    extends MockNodeContext {
        private AtomicBoolean startupDone;

        protected ManagedExtensionNodeContext(TestNodeRegistry registry, Address thisAddress, boolean isStarted) {
            super(registry, thisAddress);
            this.startupDone = new AtomicBoolean(isStarted);
        }

        public NodeExtension createNodeExtension(Node node) {
            return new DefaultNodeExtension(node){

                public boolean isStartCompleted() {
                    return ManagedExtensionNodeContext.this.startupDone.get() && super.isStartCompleted();
                }
            };
        }

        public void setStartupDone(boolean started) {
            this.startupDone.set(started);
        }
    }
}

