/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.collections;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientSetTest
extends HazelcastTestSupport {
    private TestHazelcastFactory hazelcastFactory;
    private ISet<String> set;

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    @Before
    public void setup() throws IOException {
        this.hazelcastFactory = new TestHazelcastFactory();
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        this.set = client.getSet(ClientSetTest.randomString());
    }

    @Test
    public void testAddAll() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("item1");
        l.add("item2");
        Assert.assertTrue((boolean)this.set.addAll(l));
        Assert.assertEquals((long)2L, (long)this.set.size());
        Assert.assertFalse((boolean)this.set.addAll(l));
        Assert.assertEquals((long)2L, (long)this.set.size());
    }

    @Test
    public void testAddRemove() {
        Assert.assertTrue((boolean)this.set.add((Object)"item1"));
        Assert.assertTrue((boolean)this.set.add((Object)"item2"));
        Assert.assertTrue((boolean)this.set.add((Object)"item3"));
        Assert.assertEquals((long)3L, (long)this.set.size());
        Assert.assertFalse((boolean)this.set.add((Object)"item3"));
        Assert.assertEquals((long)3L, (long)this.set.size());
        Assert.assertFalse((boolean)this.set.remove((Object)"item4"));
        Assert.assertTrue((boolean)this.set.remove((Object)"item3"));
    }

    @Test
    public void testIterator() {
        Assert.assertTrue((boolean)this.set.add((Object)"item1"));
        Assert.assertTrue((boolean)this.set.add((Object)"item2"));
        Assert.assertTrue((boolean)this.set.add((Object)"item3"));
        Assert.assertTrue((boolean)this.set.add((Object)"item4"));
        Iterator iter = this.set.iterator();
        Assert.assertTrue((boolean)((String)iter.next()).startsWith("item"));
        Assert.assertTrue((boolean)((String)iter.next()).startsWith("item"));
        Assert.assertTrue((boolean)((String)iter.next()).startsWith("item"));
        Assert.assertTrue((boolean)((String)iter.next()).startsWith("item"));
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)this.set.add((Object)"item1"));
        Assert.assertTrue((boolean)this.set.add((Object)"item2"));
        Assert.assertTrue((boolean)this.set.add((Object)"item3"));
        Assert.assertTrue((boolean)this.set.add((Object)"item4"));
        ClientSetTest.assertNotContains(this.set, (Object)"item5");
        ClientSetTest.assertContains(this.set, (Object)"item2");
        ArrayList<String> l = new ArrayList<String>();
        l.add("item6");
        l.add("item3");
        Assert.assertFalse((boolean)this.set.containsAll(l));
        Assert.assertTrue((boolean)this.set.add((Object)"item6"));
        ClientSetTest.assertContainsAll(this.set, l);
    }

    @Test
    public void removeRetainAll() {
        Assert.assertTrue((boolean)this.set.add((Object)"item1"));
        Assert.assertTrue((boolean)this.set.add((Object)"item2"));
        Assert.assertTrue((boolean)this.set.add((Object)"item3"));
        Assert.assertTrue((boolean)this.set.add((Object)"item4"));
        ArrayList<String> l = new ArrayList<String>();
        l.add("item4");
        l.add("item3");
        Assert.assertTrue((boolean)this.set.removeAll(l));
        Assert.assertEquals((long)2L, (long)this.set.size());
        Assert.assertFalse((boolean)this.set.removeAll(l));
        Assert.assertEquals((long)2L, (long)this.set.size());
        l.clear();
        l.add("item1");
        l.add("item2");
        Assert.assertFalse((boolean)this.set.retainAll(l));
        Assert.assertEquals((long)2L, (long)this.set.size());
        l.clear();
        Assert.assertTrue((boolean)this.set.retainAll(l));
        Assert.assertEquals((long)0L, (long)this.set.size());
    }

    @Test
    public void testListener() throws Exception {
        final CountDownLatch latch = new CountDownLatch(6);
        ItemListener<String> listener = new ItemListener<String>(){

            public void itemAdded(ItemEvent<String> itemEvent) {
                latch.countDown();
            }

            public void itemRemoved(ItemEvent<String> item) {
            }
        };
        String registrationId = this.set.addItemListener((ItemListener)listener, true);
        new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 5; ++i) {
                    ClientSetTest.this.set.add((Object)("item" + i));
                }
                ClientSetTest.this.set.add((Object)"done");
            }
        }.start();
        Assert.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
        this.set.removeItemListener(registrationId);
    }

    @Test
    public void testIsEmpty_whenEmpty() {
        Assert.assertTrue((boolean)this.set.isEmpty());
        Assert.assertEquals((long)0L, (long)this.set.size());
    }

    @Test
    public void testIsEmpty_whenNotEmpty() {
        this.set.add((Object)"item");
        Assert.assertFalse((boolean)this.set.isEmpty());
        Assert.assertEquals((long)1L, (long)this.set.size());
    }
}

