/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor;

import com.hazelcast.client.executor.tasks.MapPutRunnable;
import com.hazelcast.client.executor.tasks.SelectAllMembers;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientExecutorServiceExecuteTest {
    private static final int CLUSTER_SIZE = 3;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance server1;
    private HazelcastInstance server2;
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.server1 = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        this.server2 = this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testExecute() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        service.execute((Runnable)new MapPutRunnable(mapName));
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertSizeEventually((int)1, (Map)map);
    }

    @Test
    public void testExecute_withMemberSelector() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        SelectAllMembers selector = new SelectAllMembers();
        service.execute((Runnable)new MapPutRunnable(mapName), (MemberSelector)selector);
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertSizeEventually((int)1, (Map)map);
    }

    @Test(expected=NullPointerException.class)
    public void testExecute_whenTaskNull() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        service.execute(null);
    }

    @Test
    public void testExecuteOnKeyOwner() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        Member member = this.server1.getCluster().getLocalMember();
        final String targetUuid = member.getUuid();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server1);
        service.executeOnKeyOwner((Runnable)new MapPutRunnable(mapName), (Object)key);
        final IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((boolean)map.containsKey((Object)targetUuid));
            }
        });
    }

    @Test(expected=NullPointerException.class)
    public void testExecuteOnKeyOwner_whenKeyNull() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        service.executeOnKeyOwner((Runnable)new MapPutRunnable("map"), null);
    }

    @Test
    public void testExecuteOnMember() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        Member member = this.server1.getCluster().getLocalMember();
        final String targetUuid = member.getUuid();
        service.executeOnMember((Runnable)new MapPutRunnable(mapName), member);
        final IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((boolean)map.containsKey((Object)targetUuid));
            }
        });
    }

    @Test(expected=NullPointerException.class)
    public void testExecuteOnMember_WhenMemberNull() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        service.executeOnMember((Runnable)new MapPutRunnable("map"), null);
    }

    @Test
    public void testExecuteOnMembers() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        ArrayList<Member> collection = new ArrayList<Member>();
        final Member member1 = this.server1.getCluster().getLocalMember();
        final Member member2 = this.server2.getCluster().getLocalMember();
        collection.add(member1);
        collection.add(member2);
        service.executeOnMembers((Runnable)new MapPutRunnable(mapName), collection);
        final IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((boolean)map.containsKey((Object)member1.getUuid()));
                Assert.assertTrue((boolean)map.containsKey((Object)member2.getUuid()));
            }
        });
    }

    @Test
    public void testExecuteOnMembers_withEmptyCollection() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        ArrayList collection = new ArrayList();
        service.executeOnMembers((Runnable)new MapPutRunnable(mapName), collection);
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertSizeEventually((int)0, (Map)map);
    }

    @Test(expected=NullPointerException.class)
    public void testExecuteOnMembers_WhenCollectionNull() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        Collection collection = null;
        service.executeOnMembers((Runnable)new MapPutRunnable("task"), collection);
    }

    @Test
    public void testExecuteOnMembers_withSelector() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        SelectAllMembers selector = new SelectAllMembers();
        service.executeOnMembers((Runnable)new MapPutRunnable(mapName), (MemberSelector)selector);
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertSizeEventually((int)3, (Map)map);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExecuteOnMembers_whenSelectorNull() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        MemberSelector selector = null;
        service.executeOnMembers((Runnable)new MapPutRunnable("task"), selector);
    }

    @Test
    public void testExecuteOnAllMembers() {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        service.executeOnAllMembers((Runnable)new MapPutRunnable(mapName));
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertSizeEventually((int)3, (Map)map);
    }
}

