/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor;

import com.hazelcast.client.executor.tasks.AppendCallable;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientExecutorServiceInvokeTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testInvokeAll() throws Throwable {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        String msg = HazelcastTestSupport.randomString();
        ArrayList<AppendCallable> collection = new ArrayList<AppendCallable>();
        collection.add(new AppendCallable(msg));
        collection.add(new AppendCallable(msg));
        List results = service.invokeAll(collection);
        for (Future result : results) {
            Assert.assertEquals((Object)(msg + ":CallableResult"), result.get());
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInvokeAll_withTimeOut() throws Throwable {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        ArrayList<AppendCallable> collection = new ArrayList<AppendCallable>();
        collection.add(new AppendCallable());
        collection.add(new AppendCallable());
        service.invokeAll(collection, 1L, TimeUnit.MINUTES);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInvokeAny() throws Throwable {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        ArrayList<AppendCallable> collection = new ArrayList<AppendCallable>();
        collection.add(new AppendCallable());
        collection.add(new AppendCallable());
        service.invokeAny(collection);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInvokeAnyTimeOut() throws Throwable {
        IExecutorService service = this.client.getExecutorService(HazelcastTestSupport.randomString());
        ArrayList<AppendCallable> collection = new ArrayList<AppendCallable>();
        collection.add(new AppendCallable());
        collection.add(new AppendCallable());
        service.invokeAny(collection, 1L, TimeUnit.MINUTES);
    }
}

