/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor.durable;

import com.hazelcast.client.executor.tasks.MapPutRunnable;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientDurableExecutorServiceExecuteTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance server;
    private HazelcastInstance client;

    @Before
    public void setup() {
        this.server = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testExecute() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        service.execute((Runnable)new MapPutRunnable(mapName));
        IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertSizeEventually((int)1, (Map)map);
    }

    @Test(expected=NullPointerException.class)
    public void testExecute_whenTaskNull() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        service.execute(null);
    }

    @Test
    public void testExecuteOnKeyOwner() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        String mapName = HazelcastTestSupport.randomString();
        Member member = this.server.getCluster().getLocalMember();
        final String targetUuid = member.getUuid();
        String key = HazelcastTestSupport.generateKeyOwnedBy((HazelcastInstance)this.server);
        service.executeOnKeyOwner((Runnable)new MapPutRunnable(mapName), (Object)key);
        final IMap map = this.client.getMap(mapName);
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((boolean)map.containsKey((Object)targetUuid));
            }
        });
    }

    @Test(expected=NullPointerException.class)
    public void testExecuteOnKeyOwner_whenKeyNull() {
        DurableExecutorService service = this.client.getDurableExecutorService(HazelcastTestSupport.randomString());
        service.executeOnKeyOwner((Runnable)new MapPutRunnable("map"), null);
    }
}

