/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.io;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={QuickTest.class})
@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
public class DirectBufferTest
extends HazelcastTestSupport {
    @Parameterized.Parameter(value=0)
    public boolean memberDirectBuffer;
    @Parameterized.Parameter(value=1)
    public boolean clientDirectBuffer;
    private HazelcastInstance client;
    private HazelcastInstance server;

    @Parameterized.Parameters
    public static Collection<Boolean[]> params() {
        return Arrays.asList({false, false}, {false, true}, {true, false}, {true, true});
    }

    @After
    public void after() {
        if (this.client != null) {
            this.client.shutdown();
        }
        if (this.server != null) {
            this.server.shutdown();
        }
        Hazelcast.shutdownAll();
        HazelcastClient.shutdownAll();
    }

    @Test
    public void test() {
        int k;
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
        config.setProperty(GroupProperty.SOCKET_BUFFER_DIRECT.getName(), "" + this.memberDirectBuffer);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(GroupProperty.SOCKET_CLIENT_BUFFER_DIRECT.getName(), "" + this.clientDirectBuffer);
        this.server = Hazelcast.newHazelcastInstance((Config)config);
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        LinkedList<byte[]> values = new LinkedList<byte[]>();
        IMap map = this.client.getMap("foo");
        for (k = 0; k < 24; ++k) {
            byte[] value = DirectBufferTest.randomByteArray((int)Math.pow(2.0, k));
            values.add(value);
            map.put((Object)k, (Object)value);
        }
        for (k = 0; k < values.size(); ++k) {
            byte[] expected = (byte[])values.get(k);
            Assert.assertArrayEquals((byte[])expected, (byte[])((byte[])map.get((Object)k)));
        }
    }

    private static byte[] randomByteArray(int length) {
        byte[] bytes = new byte[length];
        new Random().nextBytes(bytes);
        return bytes;
    }
}

