/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapInMemoryFormatTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @Before
    public void setUp() throws Exception {
        this.factory = new TestHazelcastFactory();
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIMapCreation_throwsException_whenInMemoryFormat_NATIVE() throws Exception {
        Config config = this.getConfig();
        config.getMapConfig("default").setInMemoryFormat(InMemoryFormat.NATIVE);
        HazelcastInstance member = this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient();
        client.getMap("default");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNearCacheCreation_throwsException_whenInMemoryFormat_NATIVE() throws Exception {
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setInMemoryFormat(InMemoryFormat.NATIVE);
        Config config = this.getConfig();
        config.getMapConfig("default").setNearCacheConfig(nearCacheConfig);
        HazelcastInstance member = this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient();
        client.getMap("default");
    }
}

