/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={SlowTest.class})
public class ClientMapQueryStressTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private final AtomicBoolean stop = new AtomicBoolean();
    private final AtomicInteger mapSizeHolder = new AtomicInteger();
    private final AtomicInteger keySetSizeHolder = new AtomicInteger();
    private final List<Thread> threads = new ArrayList<Thread>();
    private IMap map;

    @Before
    public void setUp() throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.factory.newHazelcastInstance();
        }
        HazelcastInstance client = this.factory.newHazelcastClient();
        this.map = client.getMap("test");
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void map_size__equals__map_keySet_size() throws Exception {
        int i;
        for (i = 0; i < 5; ++i) {
            this.threads.add(new PutAllThread());
        }
        for (i = 0; i < 5; ++i) {
            this.threads.add(new KeySetThread());
        }
        this.threads.add(new SizeTesterThread());
        this.startThreads();
        ClientMapQueryStressTest.sleepSeconds((int)10);
        this.stopThreadsAndWaitThemToDie();
        Assert.assertEquals((String)("mapSize=" + this.mapSizeHolder.get() + ", keySetSize=" + this.keySetSizeHolder.get()), (long)this.mapSizeHolder.get(), (long)this.keySetSizeHolder.get());
    }

    protected void stopThreadsAndWaitThemToDie() throws InterruptedException {
        this.stop.set(true);
        for (Thread thread : this.threads) {
            thread.join();
        }
    }

    protected void startThreads() {
        for (Thread thread : this.threads) {
            thread.start();
        }
    }

    protected Map getMap() {
        HashMap<Integer, Integer> batch = new HashMap<Integer, Integer>();
        for (int i = 0; i < 30; ++i) {
            batch.put(i, i);
        }
        return batch;
    }

    private class SizeTesterThread
    extends Thread {
        private SizeTesterThread() {
        }

        @Override
        public void run() {
            while (!ClientMapQueryStressTest.this.stop.get()) {
                int keySetSize;
                Map batch = ClientMapQueryStressTest.this.getMap();
                ClientMapQueryStressTest.this.map.putAll(batch);
                int mapSize = ClientMapQueryStressTest.this.map.size();
                if (mapSize == (keySetSize = ClientMapQueryStressTest.this.map.keySet().size())) continue;
                ClientMapQueryStressTest.this.mapSizeHolder.set(mapSize);
                ClientMapQueryStressTest.this.keySetSizeHolder.set(keySetSize);
                ClientMapQueryStressTest.this.stop.set(true);
                break;
            }
        }
    }

    private class KeySetThread
    extends Thread {
        private KeySetThread() {
        }

        @Override
        public void run() {
            while (!ClientMapQueryStressTest.this.stop.get()) {
                ClientMapQueryStressTest.this.map.keySet();
            }
        }
    }

    private class PutAllThread
    extends Thread {
        private PutAllThread() {
        }

        @Override
        public void run() {
            while (!ClientMapQueryStressTest.this.stop.get()) {
                Map batch = ClientMapQueryStressTest.this.getMap();
                ClientMapQueryStressTest.this.map.putAll(batch);
            }
        }
    }
}

