/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.listener;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.EntryExpiredListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientExpirationListenerTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private IMap map;

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
        this.map = this.client.getMap(ClientExpirationListenerTest.randomName());
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testExpirationListener_notified_afterExpirationOfEntries() throws Exception {
        int i;
        int numberOfPutOperations = 1000;
        CountDownLatch expirationEventArrivalCount = new CountDownLatch(numberOfPutOperations);
        this.map.addEntryListener((MapListener)new ExpirationListener(expirationEventArrivalCount), true);
        for (i = 0; i < numberOfPutOperations; ++i) {
            this.map.put((Object)i, (Object)i, 100L, TimeUnit.MILLISECONDS);
        }
        ClientExpirationListenerTest.sleepAtLeastMillis((long)200L);
        for (i = 0; i < numberOfPutOperations; ++i) {
            this.map.get((Object)i);
        }
        ClientExpirationListenerTest.assertOpenEventually((CountDownLatch)expirationEventArrivalCount);
    }

    @Test
    public void testExpirationAndEvictionListener_bothNotified_afterExpirationOfEntries() throws Exception {
        int i;
        int numberOfPutOperations = 1000;
        CountDownLatch expirationEventCount = new CountDownLatch(numberOfPutOperations);
        CountDownLatch evictionEventCount = new CountDownLatch(numberOfPutOperations);
        this.map.addEntryListener((MapListener)new ExpirationAndEvictionListener(expirationEventCount, evictionEventCount), true);
        for (i = 0; i < numberOfPutOperations; ++i) {
            this.map.put((Object)i, (Object)i, 100L, TimeUnit.MILLISECONDS);
        }
        ClientExpirationListenerTest.sleepAtLeastMillis((long)200L);
        for (i = 0; i < numberOfPutOperations; ++i) {
            this.map.get((Object)i);
        }
        ClientExpirationListenerTest.assertOpenEventually((CountDownLatch)evictionEventCount);
        ClientExpirationListenerTest.assertOpenEventually((CountDownLatch)expirationEventCount);
    }

    private static class ExpirationAndEvictionListener
    implements EntryExpiredListener,
    EntryEvictedListener {
        private final CountDownLatch expirationEventArrivalCount;
        private final CountDownLatch evictionEventArrivalCount;

        public ExpirationAndEvictionListener(CountDownLatch expirationEventArrivalCount, CountDownLatch evictionEventArrivalCount) {
            this.expirationEventArrivalCount = expirationEventArrivalCount;
            this.evictionEventArrivalCount = evictionEventArrivalCount;
        }

        public void entryExpired(EntryEvent event) {
            this.expirationEventArrivalCount.countDown();
        }

        public void entryEvicted(EntryEvent event) {
            this.evictionEventArrivalCount.countDown();
        }
    }

    private static class ExpirationListener
    implements EntryExpiredListener {
        private final CountDownLatch expirationEventCount;

        public ExpirationListener(CountDownLatch expirationEventCount) {
            this.expirationEventCount = expirationEventCount;
        }

        public void entryExpired(EntryEvent event) {
            this.expirationEventCount.countDown();
        }
    }
}

