/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.map.impl.nearcache.ClientMapInvalidationListener;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.IMapDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractNearCacheLeakTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestContextBuilder;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapNearCacheLeakTest
extends AbstractNearCacheLeakTest<Data, String> {
    @Parameterized.Parameter
    public InMemoryFormat inMemoryFormat;
    @Parameterized.Parameter(value=1)
    public boolean serializeKeys;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="format:{0} serializeKeys:{1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.BINARY, true}, {InMemoryFormat.BINARY, false}, {InMemoryFormat.OBJECT, true}, {InMemoryFormat.OBJECT, false});
    }

    @Before
    public void setUp() {
        this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)this.inMemoryFormat, (boolean)this.serializeKeys).setInvalidateOnChange(true);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext(int size) {
        Config config = this.createConfig();
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        IMap memberMap = member.getMap("defaultNearCache");
        IMapDataStructureAdapter dataAdapter = new IMapDataStructureAdapter(memberMap);
        dataAdapter.waitUntilLoaded();
        ClientMapNearCacheLeakTest.populateDataAdapter((DataStructureAdapter)dataAdapter, (int)size);
        NearCacheTestContextBuilder<K, V, Data, String> builder = this.createNearCacheContextBuilder();
        return builder.setDataInstance(member).setDataAdapter((DataStructureAdapter)dataAdapter).build();
    }

    protected Config createConfig() {
        return this.getConfig().setProperty(GroupProperty.PARTITION_COUNT.getName(), "5");
    }

    protected ClientConfig createClientConfig() {
        return new ClientConfig().addNearCacheConfig(this.nearCacheConfig);
    }

    private <K, V> NearCacheTestContextBuilder<K, V, Data, String> createNearCacheContextBuilder() {
        ClientConfig clientConfig = this.createClientConfig();
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap clientMap = client.getMap("defaultNearCache");
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache("defaultNearCache");
        ClientContext clientContext = ((ClientProxy)clientMap).getContext();
        RepairingTask repairingTask = clientContext.getRepairingTask("hz:impl:mapService");
        return new NearCacheTestContextBuilder(this.nearCacheConfig, client.getSerializationService()).setNearCacheInstance((HazelcastInstance)client).setNearCacheAdapter((DataStructureAdapter)new IMapDataStructureAdapter(clientMap)).setNearCache(nearCache).setNearCacheManager(nearCacheManager).setInvalidationListener(ClientMapInvalidationListener.createInvalidationEventHandler(clientMap)).setRepairingTask(repairingTask);
    }
}

