/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.NearCacheRecordStore;
import com.hazelcast.internal.nearcache.impl.DefaultNearCache;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class})
public class ClientMapRecordStateStressTest
extends HazelcastTestSupport {
    private static final String MAP_NAME = "test";
    private static final int KEY_SPACE = 100;
    private static final int TEST_RUN_SECONDS = 60;
    private static final int GET_ALL_THREAD_COUNT = 3;
    private static final int GET_THREAD_COUNT = 2;
    private static final int PUT_THREAD_COUNT = 1;
    private static final int CLEAR_THREAD_COUNT = 1;
    private static final int REMOVE_THREAD_COUNT = 1;
    private TestHazelcastFactory factory;
    private AtomicBoolean stop;

    @Before
    public void setUp() {
        this.factory = new TestHazelcastFactory();
        this.stop = new AtomicBoolean();
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void allRecordsAreInReadableStateInTheEnd() throws Exception {
        int i;
        HazelcastInstance member = this.factory.newHazelcastInstance();
        this.factory.newHazelcastInstance();
        this.factory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addNearCacheConfig(this.newNearCacheConfig());
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap memberMap = member.getMap(MAP_NAME);
        for (int i2 = 0; i2 < 100; ++i2) {
            memberMap.put((Object)i2, (Object)i2);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i3 = 0; i3 < 1; ++i3) {
            Put put = new Put(memberMap);
            threads.add(put);
        }
        IMap clientMap = client.getMap(MAP_NAME);
        for (i = 0; i < 3; ++i) {
            GetAll getAll = new GetAll(clientMap);
            threads.add(getAll);
        }
        for (i = 0; i < 2; ++i) {
            Get get = new Get(clientMap);
            threads.add(get);
        }
        for (i = 0; i < 1; ++i) {
            Remove remove = new Remove(clientMap);
            threads.add(remove);
        }
        for (i = 0; i < 1; ++i) {
            Clear clear = new Clear(clientMap);
            threads.add(clear);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        ClientMapRecordStateStressTest.sleepSeconds((int)60);
        this.stop.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        ClientMapRecordStateStressTest.assertFinalRecordStateIsReadPermitted(clientMap);
    }

    private NearCacheConfig newNearCacheConfig() {
        return new NearCacheConfig().setName(MAP_NAME).setInvalidateOnChange(true);
    }

    private static void assertFinalRecordStateIsReadPermitted(IMap clientMap) {
        NearCachedClientMapProxy proxy = (NearCachedClientMapProxy)clientMap;
        DefaultNearCache nearCache = (DefaultNearCache)proxy.getNearCache().unwrap(DefaultNearCache.class);
        NearCacheRecordStore nearCacheRecordStore = nearCache.getNearCacheRecordStore();
        for (int i = 0; i < 100; ++i) {
            NearCacheRecord record = nearCacheRecordStore.getRecord((Object)i);
            if (record == null) continue;
            Assert.assertEquals((String)record.toString(), (long)-4L, (long)record.getRecordState());
        }
    }

    private class Get
    extends Thread {
        private final IMap<Integer, Integer> map;

        private Get(IMap<Integer, Integer> map) {
            this.map = map;
        }

        @Override
        public void run() {
            do {
                for (int i = 0; i < 100; ++i) {
                    this.map.get((Object)i);
                }
            } while (!ClientMapRecordStateStressTest.this.stop.get());
        }
    }

    private class GetAll
    extends Thread {
        private final IMap<Integer, Integer> map;

        private GetAll(IMap<Integer, Integer> map) {
            this.map = map;
        }

        @Override
        public void run() {
            HashSet<Integer> keys = new HashSet<Integer>();
            for (int i = 0; i < 100; ++i) {
                keys.add(i);
            }
            do {
                this.map.getAll(keys);
                HazelcastTestSupport.sleepAtLeastMillis((long)2L);
            } while (!ClientMapRecordStateStressTest.this.stop.get());
        }
    }

    private class Clear
    extends Thread {
        private final IMap<Integer, Integer> map;

        private Clear(IMap<Integer, Integer> map) {
            this.map = map;
        }

        @Override
        public void run() {
            do {
                this.map.clear();
                HazelcastTestSupport.sleepAtLeastMillis((long)5000L);
            } while (!ClientMapRecordStateStressTest.this.stop.get());
        }
    }

    private class Remove
    extends Thread {
        private final IMap<Integer, Integer> map;

        private Remove(IMap<Integer, Integer> map) {
            this.map = map;
        }

        @Override
        public void run() {
            do {
                for (int i = 0; i < 100; ++i) {
                    this.map.remove((Object)i);
                }
                HazelcastTestSupport.sleepAtLeastMillis((long)100L);
            } while (!ClientMapRecordStateStressTest.this.stop.get());
        }
    }

    private class Put
    extends Thread {
        private final IMap<Integer, Integer> map;

        private Put(IMap<Integer, Integer> map) {
            this.map = map;
        }

        @Override
        public void run() {
            do {
                for (int i = 0; i < 100; ++i) {
                    this.map.put((Object)i, (Object)RandomPicker.getInt((int)100));
                }
                HazelcastTestSupport.sleepAtLeastMillis((long)100L);
            } while (!ClientMapRecordStateStressTest.this.stop.get());
        }
    }
}

