/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class GetAllTest
extends HazelcastTestSupport {
    protected TestHazelcastFactory factory = new TestHazelcastFactory();
    protected String mapName = ((Object)((Object)this)).getClass().getName();

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void ensure_supplied_number_of_keys_are_in_near_cache() throws Exception {
        int entryCount = 100000;
        String mapName = "test";
        this.factory.newHazelcastInstance();
        NearCacheConfig nearCacheConfig = new NearCacheConfig("test");
        nearCacheConfig.setInvalidateOnChange(true);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addNearCacheConfig(nearCacheConfig);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap map = client.getMap("test");
        for (int i = 0; i < 100000; ++i) {
            map.put((Object)i, (Object)i);
        }
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 0; i < 100000; ++i) {
            keys.add(i);
        }
        map.getAll(keys);
        Assert.assertEquals((long)100000L, (long)((NearCachedClientMapProxy)map).getNearCache().size());
    }
}

