/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheCreateDestroyTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void create_after_destroy_gives_fresh_query_cache_instance() {
        String mapName = "someMap";
        String queryCacheName = "testCache";
        HazelcastInstance server = this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient(ClientQueryCacheCreateDestroyTest.newClientConfigWithQueryCache("someMap", "testCache"));
        IMap clientMap = client.getMap("someMap");
        QueryCache clientQueryCache = clientMap.getQueryCache("testCache");
        clientQueryCache.destroy();
        QueryCache newQueryCache = clientMap.getQueryCache("testCache");
        Assert.assertFalse((clientQueryCache == newQueryCache ? 1 : 0) != 0);
    }

    @Test
    public void recreated_queryCache_gets_updates_from_restarted_server() {
        String mapName = "someMap";
        String queryCacheName = "testCache";
        HazelcastInstance server = this.factory.newHazelcastInstance();
        server.getMap("someMap");
        HazelcastInstance client = this.factory.newHazelcastClient(ClientQueryCacheCreateDestroyTest.newClientConfigWithQueryCache("someMap", "testCache"));
        IMap clientMap = client.getMap("someMap");
        QueryCache clientQueryCache = clientMap.getQueryCache("testCache");
        this.factory.shutdownAllMembers();
        HazelcastInstance newServer = this.factory.newHazelcastInstance();
        IMap newServerMap = newServer.getMap("someMap");
        for (int i = 0; i < 1000; ++i) {
            newServerMap.put((Object)i, (Object)i);
        }
        clientQueryCache.destroy();
        clientQueryCache = clientMap.getQueryCache("testCache");
        int queryCacheSize = clientQueryCache.size();
        Assert.assertEquals((long)1000L, (long)queryCacheSize);
    }

    private static ClientConfig newClientConfigWithQueryCache(String mapName, String queryCacheName) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(50);
        QueryCacheConfig queryCacheConfig = new QueryCacheConfig(queryCacheName);
        queryCacheConfig.getPredicateConfig().setImplementation((Predicate)new TruePredicate());
        queryCacheConfig.setPopulate(true);
        clientConfig.addQueryCacheConfig(mapName, queryCacheConfig);
        return clientConfig;
    }

    @Test
    public void multiple_getQueryCache_calls_returns_same_query_cache_instance() {
        QueryCache clientQueryCache2;
        String mapName = "someMap";
        String queryCacheName = "testCache";
        HazelcastInstance server = this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient(ClientQueryCacheCreateDestroyTest.newClientConfigWithQueryCache("someMap", "testCache"));
        IMap clientMap = client.getMap("someMap");
        QueryCache clientQueryCache1 = clientMap.getQueryCache("testCache");
        Assert.assertTrue((clientQueryCache1 == (clientQueryCache2 = clientMap.getQueryCache("testCache")) ? 1 : 0) != 0);
    }
}

