/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.spi.impl.listener.SmartClientListenerService;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheDestroyResourcesTest
extends HazelcastTestSupport {
    private static final String MAP_NAME_1 = "ClientQueryCacheClientContextTest-1";
    private static final String MAP_NAME_2 = "ClientQueryCacheClientContextTest-2";
    private static final String MAP_NAME_3 = "ClientQueryCacheClientContextTest-3";
    private static final String QUERY_CACHE_NAME_1 = "query-cache-1";
    private static final String QUERY_CACHE_NAME_2 = "query-cache-2";
    private static final String QUERY_CACHE_NAME_3 = "query-cache-3";
    private TestHazelcastFactory factory;
    private IMap<String, String> map1;
    private IMap<String, String> map2;
    private IMap<String, String> map3;
    private Predicate predicate = TruePredicate.INSTANCE;
    private HazelcastInstance clientInstance;

    @Before
    public void setup() {
        Config config = this.getConfig();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addQueryCacheConfig(MAP_NAME_1, this.newQueryCacheConfig(QUERY_CACHE_NAME_1));
        clientConfig.addQueryCacheConfig(MAP_NAME_2, this.newQueryCacheConfig(QUERY_CACHE_NAME_2));
        clientConfig.addQueryCacheConfig(MAP_NAME_3, this.newQueryCacheConfig(QUERY_CACHE_NAME_3));
        this.factory = new TestHazelcastFactory();
        this.factory.newHazelcastInstance(config);
        this.clientInstance = this.factory.newHazelcastClient(clientConfig);
        this.map1 = this.clientInstance.getMap(MAP_NAME_1);
        this.map2 = this.clientInstance.getMap(MAP_NAME_2);
        this.map3 = this.clientInstance.getMap(MAP_NAME_3);
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    private QueryCacheConfig newQueryCacheConfig(String cacheName) {
        return new QueryCacheConfig(cacheName).setPredicateConfig(new PredicateConfig(this.predicate));
    }

    @Test
    public void destroy_deregisters_listeners() throws Exception {
        QueryCache queryCache1 = this.map1.getQueryCache(QUERY_CACHE_NAME_1);
        QueryCache queryCache2 = this.map2.getQueryCache(QUERY_CACHE_NAME_2);
        QueryCache queryCache3 = this.map3.getQueryCache(QUERY_CACHE_NAME_3);
        queryCache1.destroy();
        queryCache2.destroy();
        queryCache3.destroy();
        SmartClientListenerService smartListenerService = this.getSmartListenerService();
        Map registrations = smartListenerService.getRegistrations();
        Assert.assertEquals((String)registrations.toString(), (long)0L, (long)registrations.size());
    }

    protected SmartClientListenerService getSmartListenerService() {
        return (SmartClientListenerService)((HazelcastClientProxy)this.clientInstance).client.getListenerService();
    }
}

