/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.querycache;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.impl.querycache.AbstractQueryCacheTestSupport;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheEventHandlingTest
extends HazelcastTestSupport {
    private static final Predicate<Integer, Integer> TRUE_PREDICATE = TruePredicate.INSTANCE;
    private TestHazelcastFactory factory = new TestHazelcastFactory();
    private IMap<Integer, Integer> map;
    private QueryCache<Integer, Integer> queryCache;

    @Before
    public void setUp() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        String mapName = ClientQueryCacheEventHandlingTest.randomMapName();
        this.map = AbstractQueryCacheTestSupport.getMap((HazelcastInstance)client, (String)mapName);
        this.queryCache = this.map.getQueryCache("cqc", TRUE_PREDICATE, true);
    }

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    @Test
    public void testEvent_EXPIRED() throws Exception {
        int key = 1;
        int value = 1;
        final CountDownLatch latch = new CountDownLatch(1);
        this.queryCache.addEntryListener((MapListener)new EntryAddedListener(){

            public void entryAdded(EntryEvent event) {
                latch.countDown();
            }
        }, true);
        this.map.put((Object)key, (Object)value, 1L, TimeUnit.SECONDS);
        latch.await();
        ClientQueryCacheEventHandlingTest.sleepSeconds((int)1);
        this.map.get((Object)key);
        ClientQueryCacheEventHandlingTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)0L, (long)ClientQueryCacheEventHandlingTest.this.queryCache.size());
            }
        });
    }

    @Test
    public void testListenerRegistration() {
        String addEntryListener = this.queryCache.addEntryListener((MapListener)new EntryAddedListener<Integer, Integer>(){

            public void entryAdded(EntryEvent<Integer, Integer> event) {
            }
        }, true);
        String removeEntryListener = this.queryCache.addEntryListener((MapListener)new EntryRemovedListener<Integer, Integer>(){

            public void entryRemoved(EntryEvent<Integer, Integer> event) {
            }
        }, true);
        Assert.assertFalse((boolean)this.queryCache.removeEntryListener("notFound"));
        Assert.assertTrue((boolean)this.queryCache.removeEntryListener(removeEntryListener));
        Assert.assertFalse((boolean)this.queryCache.removeEntryListener(removeEntryListener));
        Assert.assertTrue((boolean)this.queryCache.removeEntryListener(addEntryListener));
        Assert.assertFalse((boolean)this.queryCache.removeEntryListener(addEntryListener));
    }
}

