/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.mapreduce.helpers.Employee;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheIndexTest
extends HazelcastTestSupport {
    private static final Predicate<Integer, Employee> TRUE_PREDICATE = TruePredicate.INSTANCE;
    private TestHazelcastFactory factory;

    @Before
    public void setUp() {
        Config config = this.getConfig();
        config.setProperty(GroupProperty.PARTITION_COUNT.getName(), "1");
        this.factory = new TestHazelcastFactory();
        this.factory.newHazelcastInstance(config);
    }

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void test_keySet_withPredicate() {
        String mapName = ClientQueryCacheIndexTest.randomString();
        String cacheName = ClientQueryCacheIndexTest.randomString();
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        int putCount = 111;
        for (int i = 0; i < 111; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        cache.addIndex("id", true);
        for (int i = 111; i < 222; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        int equalsOrBiggerThan = 27;
        int expectedSize = 222 - equalsOrBiggerThan;
        this.assertKeySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("id >= " + equalsOrBiggerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_keySet_withPredicate_whenValuesAreNotCached() {
        String mapName = ClientQueryCacheIndexTest.randomString();
        String cacheName = ClientQueryCacheIndexTest.randomString();
        QueryCacheConfig queryCacheConfig = new QueryCacheConfig(cacheName);
        queryCacheConfig.setDelaySeconds(1);
        queryCacheConfig.setBatchSize(3);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addQueryCacheConfig(mapName, queryCacheConfig);
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        int putCount = 111;
        for (int i = 0; i < putCount; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, false);
        cache.addIndex("__key", true);
        for (int i = putCount; i < 2 * putCount; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        int equalsOrBiggerThan = 27;
        int expectedSize = 2 * putCount - equalsOrBiggerThan;
        this.assertKeySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("__key >= " + equalsOrBiggerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_keySet_withPredicate_afterRemovals() {
        String mapName = ClientQueryCacheIndexTest.randomString();
        String cacheName = ClientQueryCacheIndexTest.randomString();
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        int putCount = 111;
        for (int i = 0; i < putCount; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        cache.addIndex("id", true);
        for (int i = 17; i < putCount; ++i) {
            map.remove((Object)i);
        }
        int smallerThan = 17;
        int expectedSize = 17;
        this.assertKeySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("id < " + smallerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_entrySet_withPredicate_whenValuesNotCached() {
        String mapName = ClientQueryCacheIndexTest.randomString();
        String cacheName = ClientQueryCacheIndexTest.randomString();
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        int putCount = 111;
        for (int i = 0; i < putCount; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, false);
        cache.addIndex("id", true);
        for (int i = 17; i < putCount; ++i) {
            map.remove((Object)i);
        }
        int smallerThan = 17;
        int expectedSize = 0;
        this.assertEntrySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("id < " + smallerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_entrySet_onIndexedKeys_whenValuesNotCached() {
        String mapName = ClientQueryCacheIndexTest.randomString();
        String cacheName = ClientQueryCacheIndexTest.randomString();
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        int putCount = 111;
        for (int i = 0; i < putCount; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, false);
        cache.addIndex("__key", true);
        for (int i = 17; i < putCount; ++i) {
            map.remove((Object)i);
        }
        int smallerThan = 17;
        int expectedSize = 17;
        this.assertEntrySetSizeEventually(expectedSize, (Predicate)new SqlPredicate("__key < " + smallerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_values_withoutIndex_whenValuesNotCached() {
        String mapName = ClientQueryCacheIndexTest.randomString();
        String cacheName = ClientQueryCacheIndexTest.randomString();
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        int putCount = 111;
        for (int i = 0; i < putCount; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, false);
        for (int i = 17; i < putCount; ++i) {
            map.remove((Object)i);
        }
        int smallerThan = 17;
        int expectedSize = 0;
        this.assertValuesSizeEventually(expectedSize, (Predicate)new SqlPredicate("__key < " + smallerThan), (QueryCache<Integer, Employee>)cache);
    }

    @Test
    public void test_values_withoutIndex_whenValuesCached() {
        String mapName = ClientQueryCacheIndexTest.randomString();
        String cacheName = ClientQueryCacheIndexTest.randomString();
        HazelcastInstance client = this.factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        int putCount = 111;
        for (int i = 0; i < putCount; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        QueryCache cache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        for (int i = 17; i < putCount; ++i) {
            map.remove((Object)i);
        }
        int smallerThan = 17;
        int expectedSize = 17;
        this.assertValuesSizeEventually(expectedSize, (Predicate)new SqlPredicate("__key < " + smallerThan), (QueryCache<Integer, Employee>)cache);
    }

    private void assertKeySetSizeEventually(final int expectedSize, final Predicate predicate, final QueryCache<Integer, Employee> cache) {
        AssertTask task = new AssertTask(){

            public void run() throws Exception {
                int size = cache.size();
                Set keySet = cache.keySet(predicate);
                Assert.assertEquals((String)("cache size = " + size), (long)expectedSize, (long)keySet.size());
            }
        };
        ClientQueryCacheIndexTest.assertTrueEventually((AssertTask)task, (long)15L);
    }

    private void assertEntrySetSizeEventually(final int expectedSize, final Predicate predicate, final QueryCache<Integer, Employee> cache) {
        AssertTask task = new AssertTask(){

            public void run() throws Exception {
                int size = cache.size();
                Set entries = cache.entrySet(predicate);
                Assert.assertEquals((String)("cache size = " + size), (long)expectedSize, (long)entries.size());
            }
        };
        ClientQueryCacheIndexTest.assertTrueEventually((AssertTask)task, (long)15L);
    }

    private void assertValuesSizeEventually(final int expectedSize, final Predicate predicate, final QueryCache<Integer, Employee> cache) {
        AssertTask task = new AssertTask(){

            public void run() throws Exception {
                int size = cache.size();
                Collection values = cache.values(predicate);
                Assert.assertEquals((String)("cache size = " + size), (long)expectedSize, (long)values.size());
            }
        };
        ClientQueryCacheIndexTest.assertTrueEventually((AssertTask)task, (long)15L);
    }
}

